% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_rt_line}
\alias{lp_rt_line}
\title{Define a vertical line on a retention time value}
\usage{
lp_rt_line(intercept, line_type = "dashed", color = "black")
}
\arguments{
\item{intercept}{A \code{numeric} value indicating the retention time
axis (x-axis) intercept.}

\item{line_type}{A \code{character} value indicating the line type.
One of \code{"solid"}, \code{"dashed"}, \code{"dotted"},
\code{"dotdash"}, \code{"longdash"}, \code{"twodash"}.}

\item{color}{A \code{character} value indicating the line color.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified RT line options stored in \code{options$rt_lines}.
It is intended for use with the \code{+} operator, which incrementally layers
new data or visual components onto the \code{lcmsPlot} object.
}
\description{
Define a vertical line on a retention time value
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:4]

## Create chromatogram plots faceted by sample
p <- lcmsPlot(raw_files) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900))) +
  lp_facets(facets = 'sample_id', ncol = 4)
p

## Add a vertical retention time reference line
p <- p + lp_rt_line(intercept = 2800, line_type = 'solid', color = 'red')
p
}
