% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_spectra}
\alias{lp_spectra}
\title{Define the spectra to plot}
\usage{
lp_spectra(
  sample_ids = NULL,
  mode = "closest_apex",
  ms_level = 1,
  rt = NULL,
  scan_index = NULL,
  interval = 3,
  spectral_match_db = NULL,
  match_target_index = NULL
)
}
\arguments{
\item{sample_ids}{A \code{character} vector specifying the sample IDs
to include in the plot. If \code{NULL}, the function uses the sample IDs
specified in the \code{lcmsPlot} object or the \code{lp_chromatogram} function.}

\item{mode}{The method to choose the scan from which to extract the spectra.
One of: \code{closest}, the closest scan to the specified RT - \code{rt} parameter);
\code{closest_apex}, the closest scan to a detected peak;
\code{across_peak}, selects scans across a detected peak at a certain interval
specified in the \code{interval} parameter.
\code{mode} is not applicable to standalone spectra.}

\item{ms_level}{The MS level to consider for the scan.}

\item{rt}{When \code{mode = "closest"}, the RT to consider.}

\item{scan_index}{The exact scan index to consider for extracting a spectrum.
\code{scan_index} and \code{mode} are mutually exclusive.}

\item{interval}{When \code{mode = "across_peak."} The RT interval to consider.}

\item{spectral_match_db}{The database containing reference spectra used
for matching and comparison with the input spectra.}

\item{match_target_index}{The index, ranked by descending match score,
identifying which reference spectrum to display in the mirror plot.}
}
\value{
This function returns another function that takes an \code{lcmsPlot}
object and produces a modified version containing the generated spectra
in its \code{data} slot. It is designed to be used with the \code{+} operator,
which serves as a layering mechanism. Each use of \code{+} incrementally enriches
the \code{lcmsPlot} object by adding new data or visual components.
}
\description{
The \code{lp_spectra} function enables the generation of spectra, which are
graphical representations of ions detected at each mass-to-charge ratio (m/z)
with their corresponding absolute or relative intensities.
}
\section{Spectra associated with chromatograms}{

A spectrum is obtained from a scan at a specific retention time (RT).
Therefore, when plotting a chromatogram together with its associated spectra,
it is common to mark the RT with a vertical line on the chromatogram
to indicate where the spectra were acquired. See the example below on
how to generate these types of spectra.
}

\section{Standalone spectra}{

Standalone spectra can also be generated, provided no chromatograms
are present (i.e., lp_chromatogram has not been used).
}

\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1]

p <- lcmsPlot(raw_files) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900))) +
  lp_spectra(mode = "closest", rt = 2785)
p
}
