% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_total_ion_current}
\alias{lp_total_ion_current}
\title{Define the total ion current (TIC)}
\usage{
lp_total_ion_current(sample_ids = NULL, type = "boxplot")
}
\arguments{
\item{sample_ids}{A \code{character} vector specifying the sample IDs
to include in the plot. If \code{NULL}, the function uses the sample IDs
specified in the \code{lcmsPlot} object.}

\item{type}{A \code{character} value indicating the type of plot;
one of \code{"boxplot"}, \code{"violin"}, \code{"jitter"}.}
}
\value{
This function returns another function that takes an \code{lcmsPlot}
object and produces a modified version containing the generated
total ion current (TIC) in its \code{data} slot. It is designed to be used
with the \code{+} operator, which serves as a layering mechanism.
Each use of \code{+} incrementally enriches the \code{lcmsPlot} object by
adding new data or visual components.
}
\description{
The \code{lp_total_ion_current} generates summary data for the
total ion current (TIC) of the selected samples.
}
\examples{
data_obj <- get_XCMSnExp_object_example()

p <- lcmsPlot(data_obj, sample_id_column = "sample_name") +
  lp_total_ion_current(type = "violin") +
  lp_arrange(group_by = "sample_id")
p
}
