% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-chromatogram.R
\name{plot_chromatogram}
\alias{plot_chromatogram}
\title{Plot chromatograms from one or more datasets}
\usage{
plot_chromatogram(datasets, supporting_datasets, options, single = FALSE)
}
\arguments{
\item{datasets}{A named \code{list} of data frames containing the primary datasets
to plot. Typically includes \code{chromatograms} and optionally \code{spectra}.}

\item{supporting_datasets}{A \code{list} of supporting data frames, such as
detected peaks, used for highlighting features.}

\item{options}{A list of plot options, controlling units, faceting,
highlighting, and other visual parameters.}

\item{single}{A \code{logical} value that indicates whether it should treat
the plot as a single dataset variant, which can affect faceting
and layout behavior. Default is \code{FALSE}.}
}
\value{
A \code{ggplot} object representing the chromatogram plot.
}
\description{
\code{plot_chromatogram()} generates a ggplot2 chromatogram plot from processed
datasets. It can handle multiple datasets, optionally highlight detected
peaks or apices, and apply faceting or grid layouts based on plot options.
}
\keyword{internal}
