% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-rt-diff.R
\name{plot_rt_diff}
\alias{plot_rt_diff}
\title{Plot an RT alignment difference plot}
\usage{
plot_rt_diff(datasets, supporting_datasets, options, single = FALSE)
}
\arguments{
\item{datasets}{A named \code{list} of data frames containing the primary datasets
to plot. For an RT difference plot the used key is \code{rt_diff}.}

\item{supporting_datasets}{A \code{list} of supporting data frames, such as
detected peaks, used for highlighting features.}

\item{options}{A list of plot options, controlling units, faceting,
highlighting, and other visual parameters.}

\item{single}{A \code{logical} value that indicates whether it should treat
the plot as a single dataset variant, which can affect faceting
and layout behavior. Default is \code{FALSE}.}
}
\value{
A \code{ggplot} object representing the RT difference plot.
}
\description{
\code{plot_rt_diff()} generates a ggplot2 from a dataset containing the
differences between raw and adjusted retention times.
}
\keyword{internal}
