% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-source.R
\name{show,ExternalDataSource-method}
\alias{show,ExternalDataSource-method}
\title{Show a summary of an instance of class \code{ExternalDataSource}}
\usage{
\S4method{show}{ExternalDataSource}(object)
}
\arguments{
\item{object}{An instance of class \code{ExternalDataSource}.}
}
\value{
Invisible \code{NULL}
}
\description{
Show a summary of an instance of class \code{ExternalDataSource}
}
\examples{
## Create dummy metadata
metadata <- data.frame(
  sample_id = c("S1", "S2"),
  sample_path = c("sample1.mzML", "sample2.mzML"),
  stringsAsFactors = FALSE
)

## Create dummy peaks
peaks <- data.frame(
  mz = c(100.1, 150.2),
  rt = c(300, 450),
  rtmin = c(290, 440),
  rtmax = c(310, 460),
  into = c(10000, 15000),
  maxo = c(2000, 2500),
  sample_index = c(1, 2)
)

## Create ExternalDataSource object
eds <- new(
  "ExternalDataSource",
  name = "Example data source",
  metadata = metadata,
  peaks = peaks
)

## Show summary
eds
}
