% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{show,lcmsPlotClass-method}
\alias{show,lcmsPlotClass-method}
\title{Plot the \code{lcmsPlotClass} object}
\usage{
\S4method{show}{lcmsPlotClass}(object)
}
\arguments{
\item{object}{An instance of class \code{lcmsPlotClass}.}
}
\value{
Invisible \code{NULL}
}
\description{
Display an instance of \code{lcmsPlotClass} class to the selected device.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

## Shows summary information as the plot has not been built yet
p <- lcmsPlot(raw_files)
p

## Shows the actual plot
p <- lcmsPlot(raw_files) +
  lp_chromatogram(aggregation_fun = "max") +
  lp_arrange(group_by = "sample_id") +
  lp_legend(position = "bottom") +
  lp_labels(legend = "Sample")

p
}
