% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/af_snp.R
\name{af_snp}
\alias{af_snp}
\title{Allele frequencies for SNP}
\usage{
af_snp(snp, LF, max_iter = 100, tol = 1e-10)
}
\arguments{
\item{snp}{vector of 0's, 1's, and 2's}

\item{LF}{Matrix of logistic factors, with intercept.
Pass in the return value from \code{\link[=lfa]{lfa()}}!}

\item{max_iter}{Maximum number of iterations for logistic regression}

\item{tol}{Numerical tolerance for convergence of logistic regression}
}
\value{
vector of allele frequencies
}
\description{
Computes individual-specific allele frequencies for a
single SNP.
}
\examples{
LF <- lfa(hgdp_subset, 4)
# pick one SNP only
snp <- hgdp_subset[ 1, ]
# allele frequency vector for that SNO only
allele_freqs_snp <- af_snp(snp, LF)
}
\seealso{
\code{\link[=af]{af()}}
}
