\name{dpcQuant}
\alias{dpcQuant}
\alias{dpcQuant.default}
\alias{dpcQuant.EList}
\alias{dpcQuantByRow}
\alias{dpcQuantByRow.default}
\alias{dpcQuantByRow.EList}
\alias{dpcImpute}
\title{Quantify Proteins Using the DPC}

\description{
Use the DPC to quantify protein expression values for a series of samples from precursor ion intensities.
}

\usage{
\method{dpcQuant}{EList}(y, protein.id = "Protein.Group", dpc = NULL, dpc.slope = 0.8,
     verbose = TRUE, chunk = 1000, ...)
\method{dpcQuantByRow}{EList}(y, dpc = NULL, dpc.slope = 0.8, verbose = TRUE, chunk = 1000, ...)
}

\arguments{
  \item{y}{
    a numeric matrix or EList of precursor log2-intensities values.
    Columns are samples and rows are precursors.
  }
  \item{protein.id}{
    protein IDs.
    Either an annotation column name (if \code{y} is an EList) or a character vector of length \code{nrow(y)}.
  }
  \item{dpc}{
    numeric vector giving intercept and slope of DPC.
    Alternatively the output objects from \code{dpc} or \code{dpcCN} are also acceptable.
  }
  \item{dpc.slope}{
    slope coefficient of DPC.
    Only used if \code{dpc} is \code{NULL}.
  }
  \item{verbose}{
    should progress information be output?
    If \code{TRUE}, then progress information is output every 1000 proteins.
  }
  \item{chunk}{
    When \code{verbose=TRUE}, how often to output progress information.
    By default, reports every 1000 proteins.
  }
  \item{\dots}{
    other arguments are passed to \code{dpcQuantHyparam}.
  }
}

\details{
Implements the DPC-Quant method, which quantifies protein log2-expression values from precursor ion data.
More generally, the function can summarize row-wise data to any higher annotation level, for example precursors to peptides or peptides to proteins.
The method represents missing values probabilistically using the DPC and returns maximum posterior estimates for all the protein log2-expression values, so that there are no missing values in the final summary.

The \code{dpc} function (or \code{dpcON} or \code{dpcCN}) is usually used to estimate the detection probability curve (DPC) before running \code{dpcQuant}, however a preset DPC slope can also be used.
If the \code{dpc} argument is \code{NULL}, then \code{dpc.slope} will be used as the DPC together with a DPC intercept estimated by \code{estimateDPCIntercept}.

The output from \code{dpcQuant} can be input to \code{dpcDE}.

\code{dpcQuantByRow} estimates log2-intensities row-wise without summarization by treating each row as a separate protein.
}

\note{
  The \code{dpcQuantByRows} function was previously called \code{dpcImpute} in limpa 3.2.0.
  The function was renamed in limpa 3.3.0 to clarify that the function is the same as \code{dpcQuant} but for each row (precursor or feature) without higher level summarization, and also to clarify that the limpa estimation process is not equivalent to straightforward imputation.
}

\value{
\code{dpcQuant()} produces an \code{EList} object with a row for each protein, with the following extra components:
  \item{other$n.observations}{matrix giving the number of missing non-missing precursor observations supporting each protein expression value.}
  \item{other$standard.error}{matrix giving the standard error of each protein expression value.}
  \item{dpc}{DPC used for the quantifications.}
  \item{prior.mean}{prior mean used for the quantification.}
  \item{prior.sd}{prior between-precursor standard deviation used for the quantifications.}
  \item{prior.logFC}{prior within-precursor standard deviation used for the quantifications.}

\code{dpcQuant()} also adds the following two columns to the \code{genes} data.frame:
  \item{NPeptides}{number of precursors (or features) for each protein.}
  \item{PropObs}{proportion of intensities that are observed (not missing). Averaged over all precursors and samples for each protein.}

\code{dpcQuantByRow()} produces an \code{EList} object with the same number of rows as \code{y}.
}

\note{
\code{dpcQuant} can take several minutes on large datasets so, by default, progress information is turned on with \code{verbose=TRUE}.
The function will run quietly if \code{verbose=FALSE} is set.
}

\references{
Li M (2024).
Linear Models and Empirical Bayes Methods for Mass Spectrometry-based Proteomics Data.
PhD Thesis, University of Melbourne.
\url{http://hdl.handle.net/11343/351600}

Li M, Cobbold SA, Smyth GK (2025).
Quantification and differential analysis of mass spectrometry proteomics data with probabilistic recovery of information from missing values.
\emph{bioRxiv} 2025/651125.
\doi{10.1101/2025.04.28.651125}
}

\seealso{
  \code{\link{dpc}}, \code{\link{dpcQuantHyperparam}}, \code{\link{dpcDE}}, \code{\link[limma]{EList-class}}.
}

\examples{
y.peptide <- simProteinDataSet(n.groups=1,samples.per.group=4,prop.missing=0.2)
y.protein <- dpcQuant(y.peptide, "Protein", dpc.slope=0.7)
}

\concept{Quantification}
