% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tomtom.R
\name{runTomTom}
\alias{runTomTom}
\title{Run TomTom on target motifs}
\usage{
runTomTom(
  input,
  database = NULL,
  outdir = "auto",
  thresh = 10,
  min_overlap = 5,
  dist = "ed",
  evalue = TRUE,
  silent = TRUE,
  meme_path = NULL,
  ...
)
}
\arguments{
\item{input}{path to .meme format file of motifs, a list of universalmotifs,
or a universalmotif data.frame object (such as the output of \code{runDreme()})}

\item{database}{path to .meme format file to use as reference database (or
list of universalmotifs). \strong{NOTE:} p-value estimates are inaccurate when
the database has fewer than 50 entries.}

\item{outdir}{directory to store tomtom results (will be overwritten if
exists). Default: location of input fasta file, or temporary location if using universalmotif input.}

\item{thresh}{report matches less than or equal to this value. If evalue =
TRUE (default), set an e-value threshold (default = 10). If evalue = FALSE,
set a value between 0-1 (default = 0.5).}

\item{min_overlap}{only report matches that overlap by this value or more,
unless input motif is shorter, in which case the shorter length is used as
the minimum value}

\item{dist}{distance metric. Valid arguments: \code{allr | ed | kullback | pearson | sandelin | blic1 | blic5 | llr1 | llr5}.
Default: \code{ed} (euclidean distance).}

\item{evalue}{whether to use E-value as significance threshold (default:
\code{TRUE}). If evalue = FALSE, uses \emph{q-value} instead.}

\item{silent}{suppress printing stderr to console (default: TRUE).}

\item{meme_path}{path to "meme/bin/" (optional). If unset, will check R
environment variable "MEME_DB (set in \code{.Renviron}), or option
"meme_db" (set with \code{option(meme_db = "path/to/meme/bin")})}

\item{...}{additional flags passed to tomtom using {cmdfun} formating (see table below for details)}
}
\value{
data.frame of match results. Contains \code{best_match_motif} column of
\code{universalmotif} objects with the matched PWM from the database, a series
of \verb{best_match_*} columns describing the TomTom results of the match, and a
\code{tomtom} list column storing the ranked list of possible matches to each
motif. If a universalmotif data.frame is used as input, these columns are
appended to the data.frame. If no matches are returned, \code{tomtom} and
\code{best_match_motif} columns will be set to \code{NA} and a message indicating
this will print.
}
\description{
TomTom compares input motifs to a database of known, user-provided motifs to
identify matches.
}
\details{
runTomTom will rank matches by significance and return a
best match motif for each input (whose properties are stored in the \verb{best_match_*}
columns) as well as a ranked list of all possible matches stored in the
\code{tomtom} list column.

Additional arguments

runTomTom() can accept all valid tomtom arguments passed to \code{...} as described in the
\href{http://meme-suite.org/doc/tomtom.html?man_type=web}{tomtom commandline reference}. For
convenience, below is a table of valid arguments, their default values, and
their description.\tabular{cccl}{
   TomTom Flag \tab allowed values \tab default \tab description \cr
   bfile \tab file path \tab \code{NULL} \tab path to background model for converting frequency matrix to log-odds score (not used when \code{dist} is set to "ed", "kullback", "pearson", or "sandelin" \cr
   motif_pseudo \tab \code{numeric} \tab 0.1 \tab pseudocount to add to motifs \cr
   xalph \tab \code{logical} \tab FALSE \tab convert alphabet of target database to alphabet of query database \cr
   norc \tab \code{logical} \tab FALSE \tab Do not score reverse complements of motifs \cr
   incomplete_scores \tab \code{logical} \tab FALSE \tab Compute scores using only aligned columns \cr
   thresh \tab \code{numeric} \tab 0.5 \tab only report matches with significance values <= this value. Unless \code{evalue = TRUE}, this value must be < 1. \cr
   internal \tab \code{logical} \tab FALSE \tab forces the shorter motif to be completely contained in the longer motif \cr
   min_overlap \tab \code{integer} \tab 1 \tab only report matches that overlap by this number of positions or more. If query motif is smaller than this value, its width is used as the min overlap for that query \cr
   time \tab \code{integer} \tab \code{NULL} \tab Maximum runtime in CPU seconds (default: no limit) \cr
}
}
\section{Citation}{
If you use \code{runTomTom()} in your analysis, please cite:

Shobhit Gupta, JA Stamatoyannopolous, Timothy Bailey and William Stafford
Noble, "Quantifying similarity between motifs", Genome Biology, 8(2):R24,
2007. \href{http://genomebiology.com/2007/8/2/R24}{full text}
\subsection{Licensing}{

The MEME Suite is free for non-profit use, but for-profit users should purchase a
license. See the \href{http://meme-suite.org/doc/copyright.html}{MEME Suite Copyright Page} for details.
}
}

\examples{
if (meme_is_installed()) {
motif <- universalmotif::create_motif("CCRAAAW")
database <- system.file("extdata", "flyFactorSurvey_cleaned.meme", package = "memes")

runTomTom(motif, database)
}
}
