% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/class_def.R
\name{is_valid}
\alias{is_valid}
\alias{is_valid,mw_context,character,character,character-method}
\alias{is_valid,mw_moverz_context,character,character,missing-method}
\alias{is_valid,mw_exactmass_context,character,character,missing-method}
\title{Check validity of context and inputs/outputs}
\usage{
is_valid(context, input_item, input_value, output_item)

\S4method{is_valid}{mw_context,character,character,character}(context, input_item, input_value, output_item)

\S4method{is_valid}{mw_moverz_context,character,character,missing}(context, input_item, input_value)

\S4method{is_valid}{mw_exactmass_context,character,character,missing}(context, input_item, input_value)
}
\arguments{
\item{context}{An mw_context object.}

\item{input_item}{An mw_input_item object, or the name of one.}

\item{input_value}{The value for the input item (character).}

\item{output_item}{An mw_output_item, or the name of one.}
}
\value{
TRUE or an error.
}
\description{
Compares the input and output items to the expected values for a context and 
returns TRUE if the inputs/puts are valid for the provided context or an 
error if not. This method is used internally and not for intended for general
use.
}
\examples{
is_valid(context$study,
  input_item$study_id$name,
  'ST000001',
  output_item$summary$name
)
}
