% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRNANameConverter.R
\docType{methods}
\name{checkMiRNAName}
\alias{checkMiRNAName}
\alias{checkMiRNAName,MiRNANameConverter-method}
\title{Check miRNA names for validity}
\usage{
checkMiRNAName(this, miRNAs, verbose = FALSE)

\S4method{checkMiRNAName}{MiRNANameConverter}(this, miRNAs, verbose = FALSE)
}
\arguments{
\item{this}{Object of class 'MiRNANameConverter'}

\item{miRNAs}{A character vector of miRNA names}

\item{verbose}{A boolean to either show more (TRUE) or less
information (FALSE)}
}
\value{
A character vector containing a set of valid miRNA names
}
\description{
This function checks for a given set of mature 'miRNAs' (names)
Check miRNA names for validity

This function checks for a given set of mature 'miRNAs' (names)
if the names are listed in any miRBase version respectively.
}
\details{
This function takes the input miRNA names and checks each one of them for
validity. The check is done by taking each miRNA and searches for an existing
entry in the miRBase database among all versions. miRNAs that are listed in
any version will be comprised in the return vector respectively. If no valid
miRNA was detected, a \code{character(0)} will be returned.
}
\section{Methods (by class)}{
\itemize{
\item \code{MiRNANameConverter}: Method for checking for valid miRNA names
}}

\examples{
nc = MiRNANameConverter() # Instance of class 'MiRNANameConverter'
# Test with correct inputs
checkMiRNAName(nc, miRNAs = c("hsa-miR-29a", "hsa-miR-642"))

}
\author{
Stefan Haunsberger
}
