% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRNANameConverter.R
\docType{package}
\name{miRNAmeConverter}
\alias{miRNAmeConverter}
\alias{miRNAmeConverter-package}
\title{MiRNANameConverter constructor}
\description{
This function returns an instance of a MiRNANAmeConverter class.
Handling mature miRNA names from different miRBase versions
This package contains algorithms for dealing with mature miRNA names
from different miRBase release versions. The functions are provided in form
of methods as part of the \code{MiRNANameConverter}-class. The data of all
the miRBase release versions is stored in the \code{miRBaseVersions.db}
annotation package.
The \emph{MiRNAmeConverter} package contains one class that has two
categories of functions: getters-functions and algorithms.
}
\section{Classes}{

The \code{MiRNANameConverter}
}

\section{Getter functions}{

The getter functions provide access to the slots of the class.
}

\section{Algorithms}{

There are three algorithms for dealing with miRNA names from different
miRBase releases, the \code{\link{assessVersion}},
\code{\link{checkMiRNAName}} and \code{\link{translateMiRNAName}}.
\describe{
  \item{\code{\link{translateMiRNAName}}}{The algorithm coded in this
         function can translate given miRNA names to different
         miRBase release versions.}
  \item{\code{\link{checkMiRNAName}}}{This function is used to check if a
         given miRNA name is listed in the current miRBase release.}
  \item{\code{\link{assessVersion}}}{The \emph{assessVersion}}-function is
         useful when one wants to assess the miRBase version of a given set
         of mature miRNA names.
}
}

\examples{
# Translate a mature miRNA name to miRBase version 21.0
nc = MiRNANameConverter(); # Object instantiation
translateMiRNAName(nc, "hsa-miR-29a", version = 21.0)
}
\seealso{
\emph{miRBaseVersions.db} for more information about the
database holding all major miRBase release versions)
}
\author{
Stefan Haunsberger \email{stefanhaunsberger@rcsi.ie}
}
