% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_CEA}
\alias{module_CEA}
\title{module_CEA}
\usage{
module_CEA(ceRExp, mRExp = NULL, Cancergenes, Modulelist)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{Cancergenes}{A SummarizedExperiment object: a list of cancer genes given.}

\item{Modulelist}{List object: a list of the identified miRNA sponge modules.}
}
\value{
Cancer enrichment significance p-values of the identified miRNA sponge modules
}
\description{
Cancer enrichment analysis of miRNA sponge modules using hypergeometric distribution test
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM.CEA.pvalue <- module_CEA(ceRExp, mRExp, BRCA_genes, 
                              miRSM_WGCNA_SRVC_genes)

}
\references{
Johnson NL, Kotz S, Kemp AW (1992) 
"Univariate Discrete Distributions", Second Edition. New York: Wiley.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
