% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_WGCNA}
\alias{module_WGCNA}
\title{module_WGCNA}
\usage{
module_WGCNA(
  ceRExp,
  mRExp = NULL,
  RsquaredCut = 0.9,
  num.ModuleceRs = 2,
  num.ModulemRs = 2
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{RsquaredCut}{Desired minimum scale free topology fitting index 
R^2 with interval [0 1].}

\item{num.ModuleceRs}{The minimum number of ceRNAs in each module.}

\item{num.ModulemRs}{The minimum number of mRNAs in each module.}
}
\value{
GeneSetCollection object: a list of module genes.
}
\description{
Identification of co-expressed gene modules from matched ceRNA and mRNA
expression data or single gene expression data using WGCNA package
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp[, seq_len(80)], 
    mRExp[, seq_len(80)])

}
\references{
Langfelder P, Horvath S. WGCNA: an R package for weighted 
correlation network analysis. BMC Bioinformatics. 2008, 9:559.#'
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
