% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_clust}
\alias{module_clust}
\title{module_clust}
\usage{
module_clust(
  ceRExp,
  mRExp = NULL,
  cluster.method = "kmeans",
  num.modules = 10,
  num.ModuleceRs = 2,
  num.ModulemRs = 2
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{cluster.method}{Specification of the clustering method, 
including 'kmeans'(default), 'hclust', 'dbscan' , 'clique', 
'gmm', 'som' and 'fcm'.}

\item{num.modules}{Parameter of the number of modules to be identified
for the 'kmeans', 'hclust', 'gmm' and 'fcm' methods. Parameter of the number
of intervals for the 'clique' method. For the 'dbscan' and 'som' methods,
no need to set the parameter.}

\item{num.ModuleceRs}{The minimum number of ceRNAs in each module.}

\item{num.ModulemRs}{The minimum number of mRNAs in each module.}
}
\value{
GeneSetCollection object: a list of module genes.
}
\description{
Identification of gene modules from matched ceRNA and mRNA 
expression data or single gene expression data using a series of clustering packages, 
including stats, flashClust, dbscan, subspace, mclust, SOMbrero and ppclust packages.
}
\examples{
data(BRCASampleData)
modulegenes_clust <- module_clust(ceRExp[, seq_len(30)],
    mRExp[, seq_len(30)])

}
\references{
Forgy EW. Cluster analysis of multivariate 
data: efficiency vs interpretability of classifications. 
Biometrics, 1965, 21:768-769.

Hartigan JA, Wong MA. 
Algorithm AS 136: A K-means clustering algorithm. 
Applied Statistics, 1979, 28:100-108.

Lloyd SP. Least squares quantization in PCM. 
Technical Note, Bell Laboratories. Published in 1982 
in IEEE Transactions on Information Theory, 1982, 28:128-137.

MacQueen J. Some methods for classification 
and analysis of multivariate observations. 
In Proceedings of the Fifth Berkeley Symposium on 
Mathematical Statistics and Probability, 
eds L. M. Le Cam & J. Neyman, 1967, 1, pp.281-297. 
Berkeley, CA: University of California Press.

Langfelder P, Horvath S. Fast R Functions for 
Robust Correlations and Hierarchical Clustering. 
Journal of Statistical Software. 2012, 46(11):1-17.

Ester M, Kriegel HP, Sander J, Xu X. A density-based 
algorithm for discovering clusters in large spatial databases with 
noise, Proceedings of 2nd International Conference on Knowledge Discovery and
Data Mining (KDD-96), 1996, 96(34): 226-231.

Campello RJGB, Moulavi D, Sander J. 
Density-based clustering based on hierarchical density estimates,
Pacific-Asia conference on knowledge discovery and data mining. 
Springer, Berlin, Heidelberg, 2013: 160-172.

Agrawal R, Gehrke J, Gunopulos D, Raghavan P. 
Automatic subspace clustering of high dimensional data for 
data mining applications. In Proc. ACM SIGMOD, 1998.

Scrucca L, Fop M, Murphy TB, Raftery AE. 
mclust 5: clustering, classification and density estimation using 
Gaussian finite mixture models The R Journal 8/1, 2016, pp. 205-233.

Kohonen T. Self-Organizing Maps. 
Berlin/Heidelberg: Springer-Verlag, 3rd edition, 2001.

Dunn JC. A fuzzy relative of the ISODATA process 
and its use in detecting compact well-separated clusters. Journal of Cybernetics, 
1973, 3(3):32-57.

Bezdek JC. Cluster validity with fuzzy sets. Journal of Cybernetics, 1974, 3: 58-73.

Bezdek JC. Pattern recognition with fuzzy objective function 
algorithms. Plenum, NY, 1981.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
