% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getDominant.R
\name{getDominant}
\alias{getDominant}
\alias{addDominant}
\alias{getDominant,SummarizedExperiment-method}
\alias{addDominant,SummarizedExperiment-method}
\title{Get dominant taxa}
\usage{
getDominant(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  group = rank,
  rank = NULL,
  other.name = "Other",
  n = NULL,
  complete = TRUE,
  ...
)

addDominant(x, name = "dominant_taxa", other.name = "Other", n = NULL, ...)

\S4method{getDominant}{SummarizedExperiment}(
  x,
  assay.type = assay_name,
  assay_name = "counts",
  group = rank,
  rank = NULL,
  other.name = "Other",
  n = NULL,
  complete = TRUE,
  ...
)

\S4method{addDominant}{SummarizedExperiment}(
  x,
  name = "dominant_taxa",
  other.name = "Other",
  n = NULL,
  complete = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{group}{\code{Character scalar}. Defines a group. Must be one of the
columns from \code{rowData(x)}. (Default: \code{NULL})}

\item{rank}{Deprecated. Use \code{group} instead.}

\item{other.name}{\code{Character scalar}. A name for features that are not
included in n the most frequent dominant features in the data.
(Default: \code{"Other"})}

\item{n}{\code{Numeric scalar}. The number of features that are the most
frequent
dominant features. Default is NULL, which defaults that each sample is
assigned
a dominant taxon. (Default: \code{NULL})}

\item{complete}{\code{Logical scalar}. A value to manage multiple dominant
taxa for a sample.
Default for getDominant is TRUE to include all equally dominant taxa
for each sample. complete = FALSE samples one taxa for the samples that have
multiple.
Default for addDominant is FALSE to add a column with only one
dominant taxon assigned for each sample into colData. complete = TRUE adds a
list that includes all dominant taxa for each sample into colData.}

\item{...}{Additional arguments passed on to \code{agglomerateByRank()} when
\code{rank} is specified.}

\item{name}{\code{Character scalar}. A name for the column of the
\code{colData} where results will be stored.
(Default: \code{"dominant_taxa"})}
}
\value{
\code{getDominant} returns a named character vector \code{x}
while \code{addDominant} returns
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
with additional column in
\code{\link[SummarizedExperiment:colData]{colData}} named \code{*name*}.
}
\description{
These functions return information about the most dominant taxa in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.
}
\details{
\code{addDominant} extracts the most abundant taxa in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object, and stores the information in the \code{colData}. It is a wrapper for
\code{getDominant}.

With \code{group} parameter, it is possible to agglomerate rows based on
groups. If the value is one of the columns in \code{taxonomyRanks()},
\code{agglomerateByRank()} is applied. Otherwise,
\code{agglomerateByVariable()} is utilized.
E.g. if 'Genus' rank is used, all abundances of same Genus
are added together, and agglomerated features are returned.
See corresponding functions for additional arguments to deal with
missing values or special characters.
}
\examples{
data(GlobalPatterns)
x <- GlobalPatterns

# Finds the dominant taxa.
sim.dom <- getDominant(x, group = "Genus")

# Add information to colData
x <- addDominant(x, group = "Genus", name ="dominant_genera")
colData(x)
}
