% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADDIS-spending.R
\name{ADDIS_spending}
\alias{ADDIS_spending}
\title{ADDIS-spending: Adaptive discarding algorithm for online FWER control}
\usage{
ADDIS_spending(
  d,
  alpha = 0.05,
  gammai,
  lambda = 0.25,
  tau = 0.5,
  dep = FALSE,
  display_progress = FALSE
)
}
\arguments{
\item{d}{Either a vector of p-values, or a dataframe with three columns: an
identifier (`id'), p-value (`pval'), and lags (`lags').}

\item{alpha}{Overall significance level of the procedure, the default is
0.05.}

\item{gammai}{Optional vector of \eqn{\gamma_i}. A default is provided with
\eqn{\gamma_j} proportional to \eqn{1/j^(1.6)}.}

\item{lambda}{Optional parameter that sets the threshold for `candidate'
hypotheses. Must be between 0 and 1, defaults to 0.25.}

\item{tau}{Optional threshold for hypotheses to be selected for testing. Must
be between 0 and 1, defaults to 0.5.}

\item{dep}{Logical. If \code{TRUE} runs the version for locally dependent
p-values}

\item{display_progress}{Logical. If \code{TRUE} prints out a progress bar for the algorithm runtime.}
}
\value{
\item{out}{A dataframe with the original p-values \code{pval}, the
  adjusted testing levels \eqn{\alpha_i} and the indicator function of
  discoveries \code{R}. Hypothesis \eqn{i} is rejected if the \eqn{i}-th
  p-value is less than or equal to \eqn{\alpha_i}, in which case \code{R[i] =
  1}  (otherwise \code{R[i] = 0}).}
}
\description{
Implements the ADDIS algorithm for online FWER control, where ADDIS stands
for an ADaptive algorithm that DIScards conservative nulls, as presented by
Tian and Ramdas (2021). The procedure compensates for the power loss of
Alpha-spending, by including both adaptivity in the fraction of null
hypotheses and the conservativeness of nulls.
}
\details{
The function takes as its input either a vector of p-values, or a dataframe
with three columns: an identifier (`id'), p-value (`pval'), and lags, if the
dependent version is specified (see below). Given an overall significance
level \eqn{\alpha}, ADDIS depends on constants \eqn{\lambda} and \eqn{\tau},
where \eqn{\lambda < \tau}. Here \eqn{\tau \in (0,1)} represents the
threshold for a hypothesis to be selected for testing: p-values greater than
\eqn{\tau} are implicitly `discarded' by the procedure, while \eqn{\lambda
\in (0,1)} sets the threshold for a p-value to be a candidate for rejection:
ADDIS-spending will never reject a p-value larger than \eqn{\lambda}. The
algorithms also require a sequence of non-negative non-increasing numbers
\eqn{\gamma_i} that sum to 1.

The ADDIS-spending procedure provably controls the FWER in the strong sense
for independent p-values. Note that the procedure also controls the
generalised familywise error rate (k-FWER) for \eqn{k > 1} if \eqn{\alpha} is
replaced by min(\eqn{1, k\alpha}).

Tian and Ramdas (2021) also presented a version for handling local
dependence. More precisely, for any \eqn{t>0} we allow the p-value \eqn{p_t}
to have arbitrary dependence on the previous \eqn{L_t} p-values. The fixed
sequence \eqn{L_t} is referred to as `lags', and is given as the input
\code{lags} for this version of the ADDIS-spending algorithm.

Further details of the ADDIS-spending algorithms can be found in Tian and
Ramdas (2021).
}
\examples{
sample.df <- data.frame(
id = c('A15432', 'B90969', 'C18705', 'B49731', 'E99902',
    'C38292', 'A30619', 'D46627', 'E29198', 'A41418',
    'D51456', 'C88669', 'E03673', 'A63155', 'B66033'),
pval = c(2.90e-08, 0.06743, 0.01514, 0.08174, 0.00171,
        3.60e-05, 0.79149, 0.27201, 0.28295, 7.59e-08,
        0.69274, 0.30443, 0.00136, 0.72342, 0.54757),
lags = rep(1,15))

ADDIS_spending(sample.df) #independent

ADDIS_spending(sample.df, dep = TRUE) #Locally dependent

}
\references{
Tian, J. and Ramdas, A. (2021). Online control of the familywise
  error rate. \emph{Statistical Methods for Medical Research} 30(4):976–993.
}
\seealso{
\code{\link{ADDIS}} provides online control of the FDR.
}
