% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bonfInfinite.R
\name{bonfInfinite}
\alias{bonfInfinite}
\title{Online FDR control based on a Bonferroni-like test}
\usage{
bonfInfinite(
  d,
  alpha = 0.05,
  alphai,
  random = TRUE,
  date.format = "\%Y-\%m-\%d"
)
}
\arguments{
\item{d}{Either a vector of p-values, or a dataframe with three columns: an
identifier (`id'), date (`date') and p-value (`pval'). If no column of dates
is provided, then the p-values are treated as being ordered in sequence,
arriving one at a time.}

\item{alpha}{Overall significance level of the FDR procedure, the default is
0.05.}

\item{alphai}{Optional vector of \eqn{\alpha_i}, where hypothesis \eqn{i} is
rejected if the \eqn{i}-th p-value is less than or equal to \eqn{\alpha_i}.
A default is provided as proposed by Javanmard and Montanari (2018),
equation 31.}

\item{random}{Logical. If \code{TRUE} (the default), then the order of the
p-values in each batch (i.e. those that have exactly the same date) is
randomised.}

\item{date.format}{Optional string giving the format that is used for dates.}
}
\value{
\item{d.out}{ A dataframe with the original data \code{d} (which
 will be reordered if there are batches and \code{random = TRUE}), the
 adjusted signifcance thresholds \code{alphai} and the indicator function of
 discoveries \code{R}, where \code{R[i] = 1} corresponds to hypothesis
 \eqn{i} being rejected (otherwise \code{R[i] = 0}).}
}
\description{
This funcion is deprecated, please use \code{\link{Alpha_spending}} instead.
}
\details{
Implements online FDR control using a Bonferroni-like test.

The function takes as its input either a vector of p-values, or a dataframe
with three columns: an identifier (`id'), date (`date') and p-value (`pval').
The case where p-values arrive in batches corresponds to multiple instances of
the same date. If no column of dates is provided, then the p-values are
treated as being ordered in sequence, arriving one at a time.

The procedure controls FDR for a potentially infinite stream of p-values by
using a Bonferroni-like test. Given an overall significance level
\eqn{\alpha}, we choose a (potentially infinite) sequence of non-negative
numbers \eqn{\alpha_i} such that they sum to \eqn{\alpha}. Hypothesis \eqn{i}
is rejected if the \eqn{i}-th p-value is less than or equal to \eqn{\alpha_i}.
}
\references{
Javanmard, A. and Montanari, A. (2018) Online Rules for Control of
 False Discovery Rate and False Discovery Exceedance. \emph{Annals of
 Statistics}, 46(2):526-554.
}
