% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earthworm2human_map.R
\name{earthworm2human_map}
\alias{earthworm2human_map}
\title{Earthworm to human map}
\usage{
earthworm2human_map(evalue_threshold = NULL, save_dir = cache_dir())
}
\arguments{
\item{evalue_threshold}{Only include mappings with an E-value
below a set threshold. 
See \href{https://www.metagenomics.wiki/tools/blast/evalue}{here} 
for further guidance.}

\item{save_dir}{Directory to save mapping file to.}
}
\value{
\link[data.table]{data.table} 
containing earthworm-to-human gene orthologs.
}
\description{
Orthologous gene mapping between earthworm (Eisenia andrei) and
human (Homo sapiens) genes.
}
\details{
These mappings were generated using 
\href{https://blast.ncbi.nlm.nih.gov/Blast.cgi}{BLAST} 
(a protein sequence tool) implemented within 
\href{https://elifesciences.org/articles/66747}{SAMap}.
This mapping data was provided upon request by the authors of  
\href{https://doi.org/10.1093/nar/gkac633}{Wang et al. 2022}.
Column names were collected from 
\href{https://www.metagenomics.wiki/tools/blast/blastn-output-format-6}{
Metagenomics Wiki}.
}
\keyword{internal}
