% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_orthologs_gprofiler.R
\name{map_orthologs_gprofiler}
\alias{map_orthologs_gprofiler}
\title{Map orthologs: gprofiler}
\usage{
map_orthologs_gprofiler(
  genes,
  input_species,
  output_species = "human",
  filter_na = FALSE,
  mthreshold = Inf,
  verbose = TRUE,
  ...,
  chunked = TRUE,
  chunk_size = 20000,
  retry = 3,
  retry_backoff = 1,
  n_cores = 1
)
}
\arguments{
\item{genes}{Gene list.}

\item{input_species}{Input species.}

\item{output_species}{Output species. Default "human".}

\item{filter_na}{Logical indicating whether to filter out results without a corresponding target name.}

\item{mthreshold}{Maximum number of ortholog names per gene to show.}

\item{verbose}{Logical; print progress.}

\item{...}{Additional arguments passed to \link[gprofiler2]{gorth}.}

\item{chunked}{Logical; if TRUE, query g:Profiler in chunks and rbind results.}

\item{chunk_size}{Integer; number of genes per chunk when chunked=TRUE.}

\item{retry}{Integer; number of attempts per chunk (>=1). Only used when chunked=TRUE.}

\item{retry_backoff}{Numeric; base backoff (seconds). Sleep = retry_backoff * attempt.}
}
\value{
Ortholog map \code{data.frame}
}
\description{
Map orthologs from one species to another using \link[gprofiler2]{gorth}.
}
\keyword{internal}
