% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pathwayCategories}
\alias{pathwayCategories}
\title{Top-level pathway categories}
\format{
A data frame (tibble) with 3499 rows and 5 columns
\describe{
\item{pathwayId}{Reactome, Hallmark, or KEGG pathway identifier}
\item{pathwayName}{Pathway name}
\item{topLevelPathway}{Top hierarchy pathway term, shortened in some cases}
\item{groupedPathway}{Top grouped pathway}
\item{topLevelOriginal}{Original top pathway name}
}
}
\source{
See \url{https://reactome.org/},
\url{https://www.gsea-msigdb.org/gsea/msigdb/collections.jsp}, and
\url{https://kegg.jp} for information on each of these databases.
}
\usage{
data(pathwayCategories)
}
\value{
An object of class "tbl", "tbl.df", "data.frame"
}
\description{
A data frame containing all Reactome, Hallmark, and KEGG
pathways/terms, along with a manually-curated top-level category for each
entry.
}
\keyword{datasets}
