% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaExplorer.R
\name{pcaExplorer}
\alias{pcaExplorer}
\title{Explore a dataset from a PCA perspective}
\usage{
pcaExplorer(
  dds = NULL,
  dst = NULL,
  countmatrix = NULL,
  coldata = NULL,
  pca2go = NULL,
  annotation = NULL,
  runLocal = TRUE
)
}
\arguments{
\item{dds}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object. If not provided, then a \code{countmatrix}
and a \code{coldata} need to be provided. If none of the above is provided, it is possible
to upload the data during the execution of the Shiny App}

\item{dst}{A \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}} object. Can be computed from the \code{dds} object
if left NULL. If none is provided, then a \code{countmatrix}
and a \code{coldata} need to be provided. If none of the above is provided, it is possible
to upload the data during the execution of the Shiny App}

\item{countmatrix}{A count matrix, with genes as rows and samples as columns. If not provided, it is possible
to upload the data during the execution of the Shiny App}

\item{coldata}{A data.frame containing the info on the covariates of each sample. If not provided, it is possible
to upload the data during the execution of the Shiny App}

\item{pca2go}{An object generated by the \code{\link[=pca2go]{pca2go()}} function, which contains
the information on enriched functional categories in the genes that show the top or bottom loadings
in each principal component of interest. If not provided, it is possible
to compute live during the execution of the Shiny App}

\item{annotation}{A \code{data.frame} object, with row.names as gene identifiers (e.g. ENSEMBL ids)
and a column, \code{gene_name}, containing e.g. HGNC-based gene symbols}

\item{runLocal}{A logical indicating whether the app is to be run locally or remotely on a server, which determines how documentation will be accessed.}
}
\value{
A Shiny App is launched for interactive data exploration
}
\description{
Launch a Shiny App for interactive exploration of a dataset from the perspective
of Principal Components Analysis
}
\examples{
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
                                             colData = colData(airway),
                                             design = ~dex+cell)
\dontrun{
rld_airway <- DESeq2::rlogTransformation(dds_airway)

pcaExplorer(dds_airway, rld_airway)

pcaExplorer(countmatrix = counts(dds_airway), coldata = colData(dds_airway))

pcaExplorer() # and then upload count matrix, covariate matrix (and eventual annotation)
}

}
