% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plaid.R
\name{normalize_medians}
\alias{normalize_medians}
\title{Normalize column medians of matrix}
\usage{
normalize_medians(x, ignore.zero = NULL)
}
\arguments{
\item{x}{Input matrix}

\item{ignore.zero}{Logical indicating whether to ignore zeros to
exclude for median calculation}
}
\value{
Matrix with normalized column medians.
}
\description{
This function normalizes the column medians of matrix x. It calls
optimized functions from the matrixStats package.
}
\examples{
# Create example matrix
set.seed(123)
x <- matrix(rnorm(100), nrow = 10, ncol = 10)
x[1:3, 1:3] <- 0  # Add some zeros

# Normalize medians
x_norm <- normalize_medians(x)
head(x_norm)

}
