% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-overlaps.R
\name{ginteractions-filter-overlaps}
\alias{ginteractions-filter-overlaps}
\alias{filter_by_overlaps.PinnedGInteractions}
\alias{filter_by_overlaps.GInteractions}
\alias{filter_by_non_overlaps.PinnedGInteractions}
\alias{filter_by_non_overlaps.GInteractions}
\title{Filter GInteractions overlapping with a GRanges}
\usage{
\method{filter_by_overlaps}{PinnedGInteractions}(x, y, maxgap = -1L, minoverlap = 0L)

\method{filter_by_overlaps}{GInteractions}(x, y, maxgap = -1L, minoverlap = 0L)

\method{filter_by_non_overlaps}{PinnedGInteractions}(x, y, maxgap = -1L, minoverlap = 0L)

\method{filter_by_non_overlaps}{GInteractions}(x, y, maxgap = -1L, minoverlap = 0L)
}
\arguments{
\item{x}{A (Pinned)GInteractions object}

\item{y}{A GRanges object}

\item{maxgap, minoverlap}{See \code{?\link[GenomicRanges]{countOverlaps}}
in the \pkg{GenomicRanges} package for a description of these arguments}
}
\value{
An integer vector of same length as x.
}
\description{
Filter GInteractions overlapping with a GRanges
}
\section{Pinned \code{GInteractions}}{


When using \code{filter_by_overlaps()} with a \code{PinnedGInteractions} object,
only the pinned anchors are used to check for overlap with \code{y}.
This is equivalent to specifying \code{use.region="both"} in
\code{InteractionSet::findOverlaps()}.
}

\examples{
gi <- read.table(text = "  
    chr1 11 20 - chr1 21 30 + 
    chr1 11 20 - chr1 51 55 + 
    chr1 21 30 - chr1 51 55 + 
    chr1 21 30 - chr2 51 60 +",  
    col.names = c(
        "seqnames1", "start1", "end1", "strand1", 
        "seqnames2", "start2", "end2", "strand2")
) |> as_ginteractions() |> mutate(id = 1:4, type = 'gi')

gr <- GenomicRanges::GRanges(
    c("chr1:20-30:+", "chr2:55-65:-")
) |> mutate(id = 1:2, type = 'gr')

gi

gr

####################################################################
# 1. Filter GInteractions overlapping with a subject GRanges
####################################################################

filter_by_overlaps(gi, gr)

filter_by_non_overlaps(gi, gr)

####################################################################
# 2. Filter PinnedGInteractions overlapping with a subject GRanges
####################################################################

gi |> pin_by("first") |> filter_by_overlaps(gr)

gi |> pin_by("first") |> filter_by_non_overlaps(gr)

gi |> pin_by("second") |> filter_by_overlaps(gr)

gi |> pin_by("second") |> filter_by_non_overlaps(gr)
}
