% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-overlap-left.R
\name{ginteractions-join-overlap-left}
\alias{ginteractions-join-overlap-left}
\alias{join_overlap_left.PinnedGInteractions}
\alias{join_overlap_left.GInteractions}
\alias{join_overlap_left_directed.PinnedGInteractions}
\alias{join_overlap_left_directed.GInteractions}
\title{Join overlaps between a query GInteractions and a GRanges}
\usage{
\method{join_overlap_left}{PinnedGInteractions}(x, y, maxgap = -1L, minoverlap = 0L, suffix = c(".x", ".y"))

\method{join_overlap_left}{GInteractions}(x, y, maxgap = -1L, minoverlap = 0L, suffix = c(".x", ".y"))

\method{join_overlap_left_directed}{PinnedGInteractions}(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)

\method{join_overlap_left_directed}{GInteractions}(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)
}
\arguments{
\item{x}{A (Pinned)GInteractions object}

\item{y}{A GRanges object}

\item{maxgap, minoverlap}{See \code{?\link[GenomicRanges]{countOverlaps}}
in the \pkg{GenomicRanges} package for a description of these arguments}

\item{suffix}{Suffix to add to metadata
columns (character vector of length 2, default to \code{c(".x", ".y")}).}
}
\value{
An integer vector of same length as x.
}
\description{
Join overlaps between a query GInteractions and a GRanges
}
\examples{
gi <- read.table(text = "  
    chr1 11 20 - chr1 21 30 + 
    chr1 11 20 - chr1 51 55 + 
    chr1 21 30 - chr1 51 55 + 
    chr1 21 30 - chr2 51 60 +",  
col.names = c(
    "seqnames1", "start1", "end1", "strand1", 
    "seqnames2", "start2", "end2", "strand2")
) |> as_ginteractions() |> mutate(id = 1:4, type = 'gi')

gr <- GenomicRanges::GRanges(
    c("chr1:20-30:+", "chr2:55-65:-")
) |> mutate(id = 1:2, type = 'gr')

gi

gr

####################################################################
# 1. Join overlaps between GInteractions and a subject GRanges
####################################################################

join_overlap_left(gi, gr)

join_overlap_left_directed(gi, gr)

####################################################################
# 2. Join overlaps between PinnedGInteractions and a subject GRanges
####################################################################

gi |> pin_by("first") |> join_overlap_left(gr)

gi |> pin_by("first") |> join_overlap_left_directed(gr)

gi |> pin_by("second") |> join_overlap_left(gr)

gi |> pin_by("second") |> join_overlap_left_directed(gr)
}
