% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flank.R
\name{plyinteractions-flank}
\alias{plyinteractions-flank}
\alias{flank_downstream}
\alias{flank_downstream.Ranges}
\alias{flank_downstream.PinnedGInteractions}
\alias{flank_left}
\alias{flank_left.Ranges}
\alias{flank_left.PinnedGInteractions}
\alias{flank_upstream}
\alias{flank_upstream.Ranges}
\alias{flank_upstream.PinnedGInteractions}
\alias{flank_right}
\alias{flank_right.Ranges}
\alias{flank_right.PinnedGInteractions}
\title{Generate flanking regions from pinned anchors of a GInteractions object}
\usage{
flank_downstream(x, width)

\method{flank_downstream}{Ranges}(x, width)

\method{flank_downstream}{PinnedGInteractions}(x, width)

flank_left(x, width)

\method{flank_left}{Ranges}(x, width)

\method{flank_left}{PinnedGInteractions}(x, width)

flank_upstream(x, width)

\method{flank_upstream}{Ranges}(x, width)

\method{flank_upstream}{PinnedGInteractions}(x, width)

flank_right(x, width)

\method{flank_right}{Ranges}(x, width)

\method{flank_right}{PinnedGInteractions}(x, width)
}
\arguments{
\item{x}{a PinnedGInteractions object}

\item{width}{The width of the flanking region relative to the ranges in x.
Either an integer vector of length 1 or an integer vector the same length as
x. The width can be negative in which case the flanking region is reversed.}
}
\value{
A PinnedGInteractions object
}
\description{
Generate flanking regions from pinned anchors of a GInteractions object
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30 + +
chr1 11 20 chr1 51 55 + +
chr1 11 30 chr1 51 55 - -
chr1 11 30 chr2 51 60 - -",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2", "strand1", "strand2")
) |> 
  as_ginteractions() |> 
  mutate(score = runif(4), type = c('cis', 'cis', 'cis', 'trans'))

####################################################################
# 1. Simple flanking
####################################################################

gi 

gi |> pin_by("first") |> flank_left(-2) 

gi |> pin_by("second") |> flank_downstream(4)

####################################################################
# 2. Chained flanking of each set of anchors
####################################################################

gi |> 
  pin_by("first") |> flank_left(2) |> 
  pin_by("second") |> flank_right(2)
}
