% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R, R/plyinteractions.R
\docType{package}
\name{plyinteractions-package}
\alias{plyinteractions-package}
\alias{plyinteractions}
\title{plyinteractions: Extending tidyomics verbs to genomic interactions}
\description{
plyinteractions verbs treat \code{GInteractions} objects as tabular data using
\code{dplyr}-like verbs. The functions and methods in \code{plyinteractions}
provide a grammatical approach to manipulate \code{GInteractions}, to
facilitate their integration in genomic analysis workflows.

plyinteractions is a dplyr-like API to the
GInteractions infrastructure in Bioconductor.
}
\details{
plyinteractions provides a consistent interface for importing and
wrangling genomic interactions from a variety of sources. The package
defines a grammar of genomic interactions manipulation through a set of
verbs. These verbs can be used to construct human-readable analysis
pipelines based on \code{GInteractions}.
\itemize{
\item Group genomic interactions with \code{\link[=dplyr-group_by]{group_by}};
\item Summarize grouped genomic interactions with \code{\link[=dplyr-summarize]{summarize}};
\item Tally/count grouped genomic interactions with \code{\link[=dplyr-count]{tally}} and \code{\link[=dplyr-count]{count}};
\item Modify genomic interactions with \code{\link[=dplyr-mutate]{mutate}};
\item Subset genomic interactions with \code{\link[=dplyr-filter]{filter}} using
\href{https://rlang.r-lib.org/reference/args_data_masking.html}{\verb{<data-masking>}}
and logical expressions;
\item Pick out any columns from the associated metadata with \code{\link[=dplyr-select]{select}}
using \href{https://dplyr.tidyverse.org/reference/dplyr_tidy_select.html}{\verb{<tidy-select>} arguments};
\item Subset using indices with \code{\link[=dplyr-slice]{slice}};
\item Order genomic interactions with \code{\link[=dplyr-arrange]{arrange}} using categorical/numerical
variables.

For more details on the features of plyinteractions, read the vignette:
\code{browseVignettes(package = "plyinteractions")}
}
}
\seealso{
Useful links:
\itemize{
\item \url{https://github.com/js2264/plyinteractions}
\item Report bugs at \url{https://github.com/js2264/plyinteractions/issues}
}

Useful links:
\itemize{
  \item \url{https://github.com/js2264/plyinteractions}
  \item Report bugs at \url{https://github.com/js2264/plyinteractions/issues}
}

}
\author{
Jacques Serizay

\strong{Maintainer}: Jacques Serizay \email{jacquesserizay@gmail.com}

}
\keyword{internal}
