% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-pull.R
\name{pull}
\alias{pull}
\alias{pull.PlySummarizedExperiment}
\title{extract data from object}
\usage{
\method{pull}{PlySummarizedExperiment}(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{An object Inheriting from \code{PlySummarizedExperiment}, the wrapper
class for \code{SummarizedExperiment} objects}

\item{var}{A variable as specified by \link[dplyr:pull]{dplyr::pull}}

\item{name}{ignored argument. Due to the range of data types a
\code{PlySummarizedExperiment} this argument is not supported}

\item{...}{unused argument}
}
\value{
an element from either the assays, rowData, or colData of a
\code{SummarizedExperiment} object
}
\description{
similar to \code{dplyr::pull.data.frame} except allows to extract objects
from different contexts.
}
\examples{

# last element of default context (assays)
pull(se_simple, var = -1)
# first element of rows context
pull(se_simple, var = rows(1))
# element from col context by literal variable name
pull(se_simple, var = cols(condition))

# use `pull()` to return contextual info
mutate(se_simple, rows(counts = .assays$counts)) |>
  # get last stored element
  pull(rows(-1))
}
