% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-summarise.R
\name{summarize}
\alias{summarize}
\alias{summarize.PlySummarizedExperiment}
\alias{summarise}
\alias{summarise.PlySummarizedExperiment}
\title{Summarize PlySummarizedExperiment}
\usage{
\method{summarize}{PlySummarizedExperiment}(.data, ..., .retain = c("auto", "ungrouped", "none"))

\method{summarise}{PlySummarizedExperiment}(.data, ..., .retain = c("auto", "ungrouped", "none"))
}
\arguments{
\item{.data}{An object Inheriting from \code{PlySummarizedExperiment}, the wrapper
class for \code{SummarizedExperiment} objects}

\item{...}{expressions to summarize the object}

\item{.retain}{This argument controls how \code{rowData()} or \code{colData()} is retained
after summarizing. When "auto" (the default), \code{.retain} behavior depends on
the groupings of \code{.data}. When exactly one dimension is grouped, "auto"
behaves like "ungrouped-dim", and "none" otherwise. When "ungrouped-dim",
the ungrouped dimension's data are retained in the resulting
\code{SummarizedExperiment} object and scalar outputs are recycled to the length
of the ungrouped dimension. When "none", all outputs are expected to be
scalar and only computed values are retained in \code{rowData()} and \code{colData()}}
}
\value{
an object inheriting PlySummarizedExperiment class
}
\description{
Summarize PlySummarizedExperiment
}
\examples{

# outputs in assay context may be either
# length 1, or the length of the ungrouped
# dimension while .retain = "auto"/"ungrouped-dim"
se_simple |>
  group_by(rows(direction)) |>
  summarise(
    col_sums = colSums(counts),
    sample = sample(1:20, 1L)
  )

# .retain = "none" will drop ungrouped dimensions and
# outputs of assay context should be length 1.
se_simple |>
  group_by(rows(direction)) |>
  summarise(
    col_sums = list(colSums(counts)),
    .retain = "none"
  )

# using an `across()` function will help
# nest ungrouped dimensions
se_simple |>
  group_by(rows(direction)) |>
  summarise(
    col_sums = list(colSums(counts)),
    cols(across(everything(), list)),
    .retain = "none"
  )

}
