% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcode_frequency.R
\name{create_freq_table}
\alias{create_freq_table}
\title{Frequency table}
\usage{
create_freq_table(assigned_barcodes)
}
\arguments{
\item{assigned_barcodes}{A character or integer matrix,
corresponding to the field
\code{assigned_barcodes} from \code{\link[=combinatorial_demultiplex]{combinatorial_demultiplex()}}
or the field \code{demultiplex_res$assigned_barcodes}
from \code{\link[=filter_demultiplex_res]{filter_demultiplex_res()}}.}
}
\value{
A data frame where each row corresponds to a unique observed
barcode combination. The rows are sorted in descending order of frequency.
The first columns specify the
barcode assignment (e.g \code{bc3}, \code{bc2}, \code{bc1})
and the last columns were the following:
\itemize{
\item \code{frequency}: The number of reads with the barcode combination.
\item \code{cumulative_frequency}: The cumulative frequency of
the barcode combination counted from the top.
\item \code{fraction}: The fraction of reads with the barcode combination.
\item \code{cumulative_fraction}: The cumulative fraction of the
barcode combination counted from the top.
}
}
\description{
Creates a sorted frequency table of each of the observed
barcode combinations. This function is indended to be used after running
\code{\link[=filter_demultiplex_res]{filter_demultiplex_res()}} and before creating frequency plots,
knee plots, or selecting the number of barcodes to include.
}
\examples{
library(purrr)
library(Biostrings)
input_fastq <- system.file(
    "extdata", "PETRI-seq_forward_reads.fq.gz", package = "posDemux")
reads <- readDNAStringSet(input_fastq, format = "fastq")
barcode_files <- system.file(
    "extdata/PETRI-seq_barcodes",
    c(bc1 = "bc1.fa", bc2 = "bc2.fa", bc3 = "bc3.fa"),
    package = "posDemux"
    )
names(barcode_files) <- paste0("bc", 1L:3L)
barcode_index <- map(barcode_files, readDNAStringSet)
barcodes <- barcode_index[c("bc3", "bc2", "bc1")]
sequence_annotation <- c(UMI = "P", "B", "A", "B", "A", "B", "A")
segment_lengths <- c(7L, 7L, 15L, 7L, 14L, 7L, NA_integer_)
demultiplex_res <- posDemux::combinatorial_demultiplex(
    reads, barcodes = barcodes, segments = sequence_annotation,
    segment_lengths = segment_lengths
    )
filtered_res <- filter_demultiplex_res(demultiplex_res, allowed_mismatches = 1L)
freq_table <- create_freq_table(filtered_res$demultiplex_res$assigned_barcodes)
}
