% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_filter.R
\name{filter_demultiplex_res}
\alias{filter_demultiplex_res}
\title{Filter demultiplexed reads}
\usage{
filter_demultiplex_res(demultiplex_res, allowed_mismatches)
}
\arguments{
\item{demultiplex_res}{Unprocessed output from \code{\link[=combinatorial_demultiplex]{combinatorial_demultiplex()}}.}

\item{allowed_mismatches}{Integer vector of length one or the same length
as the number of barcode segments; the threshold Hamming distance. All reads
having a number of mismatches above this number in any of the barcodes will
be filtered away.}
}
\value{
A list with the following elements:
\itemize{
\item \code{demultiplex_res}: The contents of the input argument
\code{demultiplex_res} with the sequences filtered.
\item \code{retained}: Logical vector with the same length as
the number of reads in the input. \code{TRUE} if the corresponding read
is retained.
Useful for future filtering of paired-end reads.
\item \code{summary_res}: Result of \code{\link[=create_summary_res]{create_summary_res()}} called
on the results of filtering.
}
}
\description{
Filters the demultiplexed reads from \code{\link[=combinatorial_demultiplex]{combinatorial_demultiplex()}}
such that any read exceeding the number of allowed mismatches for any
of the barcodes is removed. The function gives diagnostic information
on the number of reads removed per barcode and the total number
of reads removed.
}
\details{
The value of \code{n_removed} does not in general equal the sum of
\code{n_removed_per_barcode} since a read can have too many mismatches
with multiple barcodes.
}
\examples{
library(purrr)
library(Biostrings)
input_fastq <- system.file(
    "extdata", "PETRI-seq_forward_reads.fq.gz", package = "posDemux")
reads <- readDNAStringSet(input_fastq, format = "fastq")
barcode_files <- system.file(
    "extdata/PETRI-seq_barcodes",
    c(bc1 = "bc1.fa", bc2 = "bc2.fa", bc3 = "bc3.fa"), package = "posDemux"
    )
names(barcode_files) <- paste0("bc", 1L:3L)
barcode_index <- map(barcode_files, readDNAStringSet)
barcodes <- barcode_index[c("bc3", "bc2", "bc1")]
sequence_annotation <- c(UMI = "P", "B", "A", "B", "A", "B", "A")
segment_lengths <- c(7L, 7L, 15L, 7L, 14L, 7L, NA_integer_)
demultiplex_res <- posDemux::combinatorial_demultiplex(
    reads, barcodes = barcodes, segments = sequence_annotation,
    segment_lengths = segment_lengths
    )
filtered_res <- filter_demultiplex_res(demultiplex_res, allowed_mismatches = 1L)
freq_table <- create_freq_table(filtered_res$demultiplex_res$assigned_barcodes)
print(filtered_res$summary_res)

# This also works, but is usually not necessary to call directly
alternative_summary_res <- create_summary_res(
    retained = filtered_res$retained, barcodes = barcodes,
    assigned_barcodes = filtered_res$demultiplex_res$assigned_barcodes,
    allowed_mismatches = 1L, mismatches = demultiplex_res$mismatches
    )
}
\seealso{
\code{\link[=create_summary_res]{create_summary_res()}}
}
