% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gtracks.R
\docType{methods}
\name{plot_gtracks}
\alias{plot_gtracks}
\alias{plot_gtracks,genome_track-method}
\alias{plot_gtracks,}
\alias{genome_track}
\title{Plotting genomic tracks}
\usage{
plot_gtracks(
  obj,
  chr,
  start,
  end,
  dir = NULL,
  plot = TRUE,
  verbose = FALSE,
  dpi = 100,
  title = NULL,
  fontsize = NULL,
  width = 40,
  height = NULL,
  trackLabelFraction = 0.05,
  trackLabelHAlign = "left",
  ...
)

\S4method{plot_gtracks}{genome_track}(
  obj,
  chr,
  start,
  end,
  dir = NULL,
  plot = TRUE,
  verbose = FALSE,
  dpi = 100,
  title = NULL,
  fontsize = NULL,
  width = 40,
  height = NULL,
  trackLabelFraction = 0.05,
  trackLabelHAlign = "left",
  ...
)
}
\arguments{
\item{obj}{genome_track object. Define all tracks to be plotted.}

\item{chr}{String or numeric value to indicate the chromosome desire.}

\item{start}{Numeric. Starting position of plotting on the defined
chromosome.}

\item{end}{Numeric. Starting position of plotting on the defined chromosome.}

\item{dir}{String. Default is NULL. If defined, a string to directory and
extension to which image is exported. Extension could be png, svg or pdf.}

\item{plot}{Boolean. Default if TRUE. If FALSE, plot will not be generated,
only exported.}

\item{verbose}{If TRUE, print command that will be passed to pyGenomeTracks.}

\item{dpi}{Numeric. Default is 100}

\item{title}{String. Title of the generated plot. Default is NULL.}

\item{fontsize}{If set, global fontsize value overrides individual tracks.R .
argument of all tracks passed.}

\item{width}{Numeric. The width of the plot. Default is 40}

\item{height}{Numeric. Height of the plot. Default is NULL to set is based on
tracks height.}

\item{trackLabelFraction}{Numeric. Default is 0.05.}

\item{trackLabelHAlign}{String. Position of labels aligment. Options are
"left", "right" or "center". Default is "left".}

\item{...}{Extra arguments to be passed for generic plot().}
}
\value{
None

None
}
\description{
This is a generic function used to plot \code{genome_track} objects.
}
\note{
For this function to run, you need pyGenomeTracks
installed in R's loading enviroment. If not, please run install_pyGenomeTracks()
}
\examples{
\dontrun{
# Get example data directories
# Download h5 example
ah <- AnnotationHub()
query(ah, "rGenomeTracksData")
h5_dir <- ah[["AH95901"]]
tads_dir <- system.file("extdata", "tad_classification.bed",
  package = "rGenomeTracks"
)
arcs_dir <- system.file("extdata", "links2.links", package = "rGenomeTracks")
bw_dir <- system.file("extdata", "bigwig2_X_2.5e6_3.5e6.bw", package = "rGenomeTracks")
#
# Create HiC track from HiC matrix
h5 <- track_hic_matrix(
  file = h5_dir, depth = 250000, min_value = 5, max_value = 200,
  transform = "log1p", show_masked_bins = FALSE
)

# Create TADS track
tads <- track_domains(
  file = tads_dir, border_color = "black",
  color = "none", height = 5,
  line_width = 5,
  show_data_range = FALSE,
  overlay_previous = "share-y"
)

# Create arcs track
arcs <- track_links(
  file = arcs_dir, links_type = "triangles", line_style = "dashed",
  overlay_previous = "share-y",
  color = "darkred",
  line_width = 3,
  show_data_range = FALSE
)

# Create bigwig track
bw <- track_bigwig(
  file = bw_dir, color = "red",
  max_value = 50,
  min_value = 0,
  height = 4,
  overlay_previous = "yes",
  show_data_range = FALSE
)

# Create one object from HiC, arcs and bigwid
tracks <- h5 + arcs + bw

# Plot the tracks
plot_gtracks(tracks, chr = "X", start = 25 * 10^5, end = 31 * 10^5)
# Plot HiC, TADS and bigwig tracks
plot_gtracks(h5 + tads + bw, chr = "X", start = 25 * 10^5, end = 31 * 10^5)
}
}
\author{
Omar Elashkar

Omar Elashkar
}
\keyword{install_pyGenomeTracks}
