% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Methods.R
\name{PMPG}
\alias{PMPG}
\title{Percentage of Mono or Paraphyletic Groups}
\usage{
PMPG(tr, mt = NULL)
}
\arguments{
\item{tr}{Phylogenetic tree. If the tree contains sample names in the labels, provide
metadata. If it already contains the names of the taxa, just provide the tree.}

\item{mt}{Metadata. The metadata should have the following format: 
the first column should contain the names of the samples, 
exactly as they appear on the tree label; 
the second column should contain the corresponding taxa.
If the tree already has the labels renamed according to the taxon, 
it is not necessary to provide metadata.}
}
\value{
The `PMPG' returns a `list` containing:
\itemize{
         \item tab: a dataframe with a three-colunm output: taxa, mono and para. 
                    `mono` and `para` columns returns a boolean value. 
         \item percMono: percentage of Monophyletic taxa
         \item percPara: percentage of Paraphyletic taxa
         \item mean: the mean value of `percMono` and `percPara`
        }
}
\description{
Phylogenetic tree evaluation function, returns the percentage of Monophyletic
             and Paraphyletic taxa in the phylogenetic tree.
}
\details{
Empty or NA labels are removed from analyses
}
\examples{

# Load the sample tree and its metadata
pathtree <- system.file(package = "rSWeeP" , "examples" , "tree_Mitochondrial.tree")
tree = ape::read.tree(pathtree)
pathmetadata <- system.file(package = "rSWeeP" , "examples" , "metadata_mitochondrial.csv")
mt = read.csv(pathmetadata,header=TRUE)

data = data.frame(sp=mt$fileName,family=mt$family) 
PMPG(tree,data)

}
\author{
Camila P. Perico
}
