% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5P.R
\name{H5P_create_intermediate_group}
\alias{H5P_create_intermediate_group}
\alias{H5Pset_create_intermediate_group}
\alias{H5Pget_create_intermediate_group}
\title{Get and set whether to create missing intermediate groups}
\usage{
H5Pset_create_intermediate_group(h5plist, create_groups = TRUE)

H5Pget_create_intermediate_group(h5plist)
}
\arguments{
\item{h5plist}{An object of class \linkS4class{H5IdComponent} representing a link
creation property list.}

\item{create_groups}{A logical of length 1 specifying whether missing
groups should be created when a new object is created.  Default is \code{TRUE}.}
}
\description{
Get and set whether to create missing intermediate groups
}
\examples{
pid <- H5Pcreate("H5P_LINK_CREATE")

## by default intermediate groups are not created
H5Pget_create_intermediate_group(pid)

## Change the setting so groups will be created

H5Pget_create_intermediate_group(pid)

## tidy up
H5Pclose(pid)

}
