# global variables
.globals <- new.env(parent = emptyenv())
.globals$theme <- bs_theme(bootswatch = 'lumen')
# filenames
.globals$app_path <- "."
.globals$datafolder <- "data"
.globals$filenames <- list(
    appconf = "appconf.rds",
    sc1conf = "sc1conf.rds",
    sc1def = "sc1def.rds",
    sc1gene = "sc1gene.rds",
    sc1gexpr = "sc1gexpr.h5",
    sc1meta = "sc1meta.rds",
    sc1atac = "sc1atac.h5",
    sc1peak = 'sc1peak.rds',
    sc1link = 'sc1link.rds',
    sc1anno = 'sc1anno.rds',
    sc1edge = 'sc1edge.rds',
    coor_revmap = 'coorrevmap.rds',
    bwspath = 'bws',
    token = "token",
    locker = "LOCKER",
    cellchat = "cellchat.rds",
    monocle = "monocle3_pseudotime.rds",
    slingshot = "slingshot.rds"
)
.globals$tokenMinLen <- 8 # minimal token length
.globals$h5fGrpPrefix <- 'grp' #gene expression table prefix
.globals$h5fDataPrefix <- 'data'
.globals$h5fGrp <- paste(.globals$h5fGrpPrefix, .globals$h5fDataPrefix, sep="/") 
.globals$h5fATACcell <- 'cell' # ATAC cell level signals table prefix 
.globals$h5fATACcoor <- 'coor' # ATAC coor level signals table prefix
.globals$downloadFolder <- file.path("www", "download")
.globals$counterFilename <- file.path("www", "counter.tsv")
.globals$IPlocationFilename <- file.path("www", "iptable.rds")
.globals$credential_path <- file.path("www", "database.sqlite")
.globals$credentialTableName <- 'credentials'
.globals$passphrase <- NULL
.globals$configTableName <- 'config'
.globals$configTableSep <- ';'
.globals$counterTableName <- 'counter'
.globals$IPlocationTablename <- "iptable"
.globals$geneSymbolTableName <- 'gene'
.globals$gn2symTableName <- 'gn2sym'
.globals$commentsTableName <- 'issues'
.globals$totalComments <- 2500
.globals$commentsIntervals <- 10
.globals$searchTableName <- 'searchlog'
# for home search page, the groupColPattern
.globals$groupColPattern <- 'celltype'
# Colour palette
.globals$coExpColor <- c(
    "Red (Gene1); Blue (Gene2)",
    "Orange (Gene1); Blue (Gene2)",
    "Red (Gene1); Green (Gene2)",
    "Green (Gene1); Blue (Gene2)"
)
# Panel sizes
.globals$pList1 <- c(
    "Small" = "400px",
    "Medium" = "600px",
    "Large" = "800px")
.globals$pList2 <- c(
    "Small" = "500px",
    "Medium" = "700px",
    "Large" = "900px")
.globals$pList3 <- c(
    "Small" = "600px",
    "Medium" = "800px",
    "Large" = "1000px")
.globals$lList <- c(#ggrepel font size in scDRcell
    "Small" = 5,
    "Medium" = 6,
    "Large" = 7)
.globals$fList <- c(#monocle plot point size
    "Small" = .5,
    "Medium" = 1,
    "Large" = 2)

.globals$figWidth = 8.01
.globals$figHeight = 6.01
.globals$figFormats = c('PDF', 'PNG', 'TIFF', 'JPEG', 'BMP', 'CSV')

# supported organisms
.globals$supported_organisms <- c(
    "Bos taurus",
    "Caenorhabditis elegans",
    "Drosophila melanogaster",
    "Danio rerio",
    "Gallus gallus",
    "Homo sapiens",
    "Mus musculus",
    "Macaca mulatta",
    "Pan troglodytes",
    "Rattus norvegicus",
    "Saccharomyces cerevisiae",
    "Sus scrofa"
)
# tab terms
.globals$terms <- list(
    scRNAseq = c(
        GeneExpr = "GeneExpr",
        coexpression = "coexpression",
        expression = "expression"
    ),
    scATACseq = c(
        GeneExpr = "GeneScore",
        coexpression = "co-genescore",
        expression = "score"
    ),
    scMultiome = c(
        GeneExpr = "GeneExpr",
        coexpression = "coexpression",
        expression = "expression"
    )
)
# number of gene by search
.globals$maxHeatmapGene <- 100
.globals$maxNumGene <- 50
.globals$limitNumGene <- 3

# subset cell setting group
.globals$subsetgroup <- c('A', 'B')
