% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ks_test.R
\name{ks_test}
\alias{ks_test}
\title{ks_test}
\usage{
ks_test(counts, cexpr, lib.size, formula = NULL, BPPARAM)
}
\arguments{
\item{counts}{A non-negative integer matrix of scRNA-seq filtered read counts
from \code{filter_counts}.
The rows of the matrix are genes and columns are samples/cells.}

\item{cexpr}{A dataframe that contains the covariate values.
The rows of the dataframe are the corresponding samples/cells from the counts
matrix from \code{filter_counts}.
The cells of the dataframe are the covariates to be included in the GLM.}

\item{lib.size}{A numeric vector that contains the total number of counts
per cell from the counts matrix from \code{filter_counts}.}

\item{formula}{A regression formula to fit the covariates in the ZINB GLM.}

\item{BPPARAM}{configuration parameter related to the method of parallel execution.
For further information on how to set-up parallel execution refer to
\code{BiocParallel} vignette.}
}
\value{
List object containing the p-values from the
KS test.
}
\description{
This function is used to perform Kolmogorv-Smirnov test on the
filtered sparse counts matrix from \code{filter_counts} to select genes
belonging to the family of ZINB distributions
}
\examples{

#' # load toy  example data

data(scData)

# apply the ks_test function to subset genes belonging to the
# family of ZINB distributions.

library(BiocParallel)
scData_KS <- ks_test(counts=scData$counts, cexpr=scData$covariates, lib.size=scData$lib_size, BPPARAM=bpparam())
}
