% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotXY.R
\name{plotXY}
\alias{plotXY}
\title{Plot arbitrary x- and y-coordinates}
\usage{
plotXY(
  x,
  y,
  colour_by = color_by,
  shape_by = NULL,
  size_by = NULL,
  order_by = NULL,
  other_fields = list(),
  swap_rownames = NULL,
  color_by = NULL,
  point_fun = NULL,
  scattermore = FALSE,
  bins = NULL,
  summary_fun = "sum",
  hex = FALSE,
  ...
)
}
\arguments{
\item{x}{Vector containing the x-coordinates.
Alternatively, a data.frame with a single column.
Alternatively \code{NULL}, in which case all points are assumed to have the same categorical x-coordinate.}

\item{y}{Vector containing the y-coordinates, of same length as \code{x}.
Alternatively, a data.frame with a single column.}

\item{colour_by}{Vector containing a variable to colour by, of the same length as \code{x}.
Alternatively, a data.frame with a single column.}

\item{shape_by}{Vector containing a variable to shape by, of the same length as \code{x}.
Alternatively, a data.frame with a single column.}

\item{size_by}{Vector containing a variable to shape by, of the same length as \code{x}.
Alternatively, a data.frame with a single column.}

\item{order_by}{Specification of a column metadata field or a feature to order points by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{other_fields}{A data frame of additional columns to add to the data.frame passed to \pkg{ggplot2}.
This should have number of rows equal to the length of \code{y}.
Alternatively, a named list of vectors of length equal to that of \code{y}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labelling plot
elements.}

\item{color_by}{Alias to \code{colour_by}.}

\item{point_fun}{Function used to create a geom that shows individual cells.
Should take \code{...} args and return a ggplot2 geom. For example,
\code{point_fun=function(...) geom_quasirandom(...)}.}

\item{scattermore}{Logical, whether to use the \code{scattermore} package to
greatly speed up plotting a large number of cells. Use \code{point_size =
0} for the most performance gain.}

\item{bins}{Number of bins, can be different in x and y, to bin and summarize
the points and their values, to avoid overplotting. If \code{NULL}
(default), then the points are plotted without binning. Only used when both
x and y are numeric.}

\item{summary_fun}{Function to summarize the feature value of each point
(e.g. gene expression of each cell) when the points binned, defaults to
\code{sum}. Can be either the name of the function or the function itself.}

\item{hex}{Logical, whether to use \code{\link{geom_hex}}.}

\item{...}{Additional arguments for visualization, see
\code{?"\link{scater-plot-args}"} for details.}
}
\value{
A \link{ggplot} object.
}
\description{
Reuse \pkg{scater}'s plotting machinery for arbitrary x- and y-coordinates.
This allows users to maintain the same aesthetic style when creating plots outside of a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\examples{
x <- runif(100)
y <- rnorm(100)

# Manually add labels.
plotXY(x, y) + ggplot2::xlab("X") + ggplot2::ylab("Y")

# Insert labels via data frames.
plotXY(data.frame(foo=x), data.frame(bar=y))

col <- sample(LETTERS, length(x), replace=TRUE)
plotXY(x, y, colour_by=col) + guides(color=guide_legend("stuff"))

shape <- sample(LETTERS[1:5], length(x), replace=TRUE)
plotXY(x, y, shape=data.frame(FOO=shape))

size <- runif(length(x))
plotXY(x, y, size=data.frame(BAR=size))

plotXY(x, y, other_fields=data.frame(stuff = rbinom(100, 1, 0.5) > 0)) +
    ggplot2::facet_grid(~stuff)

}
\author{
Aaron Lun
}
