% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runAllNeighborSteps.R
\name{runAllNeighborSteps}
\alias{runAllNeighborSteps}
\title{Run all neighbor-related steps}
\usage{
runAllNeighborSteps(
  x,
  runUmap.args = list(),
  runTsne.args = list(),
  buildSnnGraph.args = list(),
  clusterGraph.args = list(),
  BNPARAM = AnnoyParam(),
  return.graph = FALSE,
  collapse.search = TRUE,
  num.threads = 3
)
}
\arguments{
\item{x}{Numeric matrix where rows are dimensions and columns are cells,
typically containing a low-dimensional representation from, e.g., \code{\link{runPca}}.

Alternatively, an index constructed by \code{\link[BiocNeighbors]{buildIndex}}.}

\item{runUmap.args}{Named list of further arguments to pass to \code{\link{runUmap}}.
This can be set to \code{NULL} to omit the UMAP.}

\item{runTsne.args}{Named list of further arguments to pass to \code{\link{runTsne}}.
This can be set to \code{NULL} to omit the t-SNE.}

\item{buildSnnGraph.args}{Named list of further arguments to pass to \code{\link{buildSnnGraph}}.
Ignored if \code{clusterGraph.args=NULL}.}

\item{clusterGraph.args}{Named list of further arguments to pass to \code{\link{clusterGraph}}.
This can be set to \code{NULL} to omit the clustering.}

\item{BNPARAM}{A \link[BiocNeighbors]{BiocNeighborParam} instance specifying the nearest-neighbor search algorithm to use.}

\item{return.graph}{Logical scalar indicating whether to return the output of \code{\link{buildSnnGraph}}.
By default, only the output of \code{\link{clusterGraph}} is returned.}

\item{collapse.search}{Logical scalar indicating whether to collapse the nearest-neighbor search for each step into a single search.
Steps that need fewer neighbors will take a subset of the neighbors from the collapsed search.
Setting this to \code{TRUE} is faster but may not give the same results as separate searches for some nearest-neighbor algorithms (e.g., approximate methods).}

\item{num.threads}{Integer scalar specifying the number of threads to use.
At least one thread should be available for each step.}
}
\value{
A named list containing the results of each step.
See each individual function for the format of the results.
}
\description{
Run all steps that require a nearest-neighbor search.
This includs \code{\link{runUmap}}, \code{\link{runTsne}} and \code{\link{buildSnnGraph}} with \code{\link{clusterGraph}}.
The idea is to build the index once, perform the neighbor search, and run each task in parallel to save time.
}
\examples{
x <- t(as.matrix(iris[,1:4]))
# (Turning down the number of threads so that R CMD check is happy.)
res <- runAllNeighborSteps(x, num.threads=2)
str(res)

}
\seealso{
\code{\link{runAllNeighborSteps.se}}, to run each neighbor-related step on a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\author{
Aaron Lun
}
