% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testEnrichment.R
\name{testEnrichment}
\alias{testEnrichment}
\title{Test for gene set enrichment}
\usage{
testEnrichment(x, sets, universe = NULL, log = FALSE, num.threads = 1)
}
\arguments{
\item{x}{Vector of identifiers for some interesting genes, e.g., symbols or Ensembl IDs.
This is usually derived from a selection of top markers, e.g., from \code{\link{scoreMarkers}}.}

\item{sets}{List of vectors of identifiers for the pre-defined gene sets.
Each inner vector corresponds to a gene set and should contain the same type of identifiers as \code{x}.}

\item{universe}{Vector of identifiers for the universe of genes in the dataset.
\code{x} and each vector in \code{sets} will be subsetted to only include those genes in \code{universe}.
If \code{NULL}, the universe is defined as the union of all genes in \code{x} and \code{sets}. 

Alternatively, an integer scalar specifying the number of genes in the universe.
This is assumed to be greater than or equal to the number of unique genes in \code{x} and \code{sets}.}

\item{log}{Logical scalar indicating whether to report log-transformed p-values.
This may be desirable to avoid underflow at near-zero p-values.}

\item{num.threads}{Integer scalar specifying the number of threads to use.}
}
\value{
\link[S4Vectors]{DataFrame} with one row per gene set and the following columns:
\itemize{
\item \code{overlap}, the overlap between \code{x} and each entry of \code{sets}, i.e., the number of genes in the intersection.
\item \code{size}, the set of each entry of \code{sets}.
\item \code{p.value}, the (possibly log-transformed) p-value for overrepresentation of the gene set in \code{x}.
}
}
\description{
Perform a hypergeometric test for enrichment of gene sets in a list of interesting genes (e.g., markers).
}
\examples{
testEnrichment(
    x=LETTERS[1:5], 
    sets=list(
        first=LETTERS[1:10],
        second=LETTERS[1:5 * 2],
        third=LETTERS[10:20]
    ),
    universe=LETTERS
)

}
\seealso{
\code{\link{phyper}} and \url{https://libscran.github.io/phyper/},
which is the basis for the underlying calculation.
}
\author{
Aaron Lun
}
