% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\docType{data}
\name{RatioMaxMax}
\alias{RatioMaxMax}
\title{RatioMaxMax class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RatioMaxMax
}
\value{
The \code{RatioMaxMax$new} function returns a \code{RatioMaxMax} 
object which contains the information about the two profiles and the 
threshold used to calculate the metric. It can be used, as many times 
needed, to calculate the specified metric.
}
\description{
An object which is a interface to calculate the ratio between 
the peaks values between two profiles.

The \code{RatioMaxMax} object is needed to 
calculate the ratio between 
the peaks values between two profiles.
A threshold and the two profiles are set during the \code{RatioMaxMax} 
object creation. If different threshold or 
profiles are needed, the \code{calculateMetric} function should be used, 
with the new profiles and threshold passed as arguments to update those
values inside the \code{RatioMaxMax} object.

The threshold is the minimum peak value accepted 
to calculate a ratio.
}
\section{Constructor}{

Create a \code{RatioMaxMax} object.

\code{RatioMaxMax$new(profile1, profile2, threshold = 1)}

The threshold is the minimum peak value accepted 
to calculate a ratio.

The \code{RatioMaxMax} object inherites those functions:
\itemize{
\item \code{getMetric} { A function that returns the value of the
calculated metric }
\item \code{getInfo} { A function that returns a description of the metric
with the metric value.}
\item \code{getType} { A function that returns the unique name associated
to this metric }
\item \code{calculateMetric} { A function that modifies the values of the
two profiles and the threshold. The new values (profile1, profile2, 
threshold) are passed as arguments.}
}
}

\seealso{
\itemize{
\item \code{\link{MetricFactory}} {for using a interface to calculate all 
available metrics separately or togheter.}
}
}
\author{
Astrid Deschenes
}
\keyword{datasets}
