% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlReports.R
\name{reportSeuratClustering}
\alias{reportSeuratClustering}
\title{Generates an HTML report for Seurat Clustering and returns the SCE object
 with the results computed and stored inside the object.}
\usage{
reportSeuratClustering(
  inSCE,
  biological.group = NULL,
  phenotype.groups = NULL,
  runClustering = TRUE,
  plotTSNE = TRUE,
  plotUMAP = TRUE,
  minResolution = 0.3,
  maxResolution = 1.5,
  numClusters = 10,
  significant_PC = 10,
  outputFile = NULL,
  outputPath = NULL,
  subtitle = NULL,
  authors = NULL,
  showSession = FALSE,
  pdf = FALSE,
  forceRun = TRUE
)
}
\arguments{
\item{inSCE}{Input \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{biological.group}{A character value that specifies the name of the
\code{colData()} column to use as the main biological group in the Seurat
report for marker selection and grouping.}

\item{phenotype.groups}{A character vector that specifies the names of the
\code{colData()} columns to use for differential expression in addition to
the \code{biological.group} parameter.}

\item{runClustering}{A logical value indicating if Clustering should be run
or not in the report. Default is \code{TRUE}. If \code{FALSE}, parameters
 \code{plotTSNE} and \code{plotUMAP} are also set to \code{FALSE}.}

\item{plotTSNE}{A logical value indicating if TSNE plots should be visualized
in the clustering section of the report. Default is \code{TRUE}.}

\item{plotUMAP}{A logical value indicating if UMAP plots should be visualized
in the clustering section of the report. Default is \code{TRUE}.}

\item{minResolution}{A numeric value indicating the minimum resolution to use
for clustering. Default \code{0.3}.}

\item{maxResolution}{A numeric value indicating the maximum resolution to use
for clustering. Default \code{1.5}.}

\item{numClusters}{temp (to remove)}

\item{significant_PC}{temp (change to pc.use)}

\item{outputFile}{Specify the name of the generated output HTML file.
If \code{NULL} then the output file name will be based on the name of the
Rmarkdown template. Default \code{NULL}.}

\item{outputPath}{Specify the name of the output directory to save the
rendered HTML file. If \code{NULL} the file is stored to the current
working directory. Default \code{NULL}.}

\item{subtitle}{A character value specifying the subtitle to use in the
report. Default \code{NULL}.}

\item{authors}{A character value specifying the names of the authors to use
in the report. Default \code{NULL}.}

\item{showSession}{A logical value indicating if session information
should be displayed or not. Default is \code{FALSE}.}

\item{pdf}{A logical value indicating if a pdf should also be generated for
each figure in the report. Default is \code{FALSE}.}

\item{forceRun}{A logical value indicating if all computations previously
computed should be re-calculated regardless if these computations are
available in the input object. Default is \code{TRUE}.}
}
\value{
A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object
 with computations stored.
}
\description{
Generates an HTML report for Seurat Clustering and returns the SCE object
 with the results computed and stored inside the object.
}
