% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runHarmony}
\alias{runHarmony}
\title{Apply Harmony batch effect correction method to SingleCellExperiment object}
\usage{
runHarmony(
  inSCE,
  useAssay = NULL,
  useReducedDim = NULL,
  batch = "batch",
  reducedDimName = "HARMONY",
  nComponents = 50,
  lambda = 0.1,
  theta = 5,
  sigma = 0.1,
  nIter = 10,
  seed = 12345,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Default \code{NULL}. It is recommended to use a reducedDim
such as PCA through the `useReducedDim` parameter of this function.}

\item{useReducedDim}{A single character indicating the name of the reducedDim
to be used. It is recommended to use a reducedDim instead of a full assay as 
using an assay might cause the algorithm to not converge and throw error.
Specifying this will ignore \code{useAssay}. Default
\code{NULL}.}

\item{batch}{A single character indicating a field in \code{colData} that
annotates the batches of each cell; or a vector/factor with the same length
as the number of cells. Default \code{"batch"}.}

\item{reducedDimName}{A single character. The name for the corrected
low-dimensional representation. Will be saved to \code{reducedDim(inSCE)}.
Default \code{"HARMONY"}.}

\item{nComponents}{An integer. The number of PCs to use and generate.
Default \code{50L}.}

\item{lambda}{A Numeric scalar. Ridge regression penalty parameter. Must be
strictly positive. Smaller values result in more aggressive correction.
Default \code{0.1}.}

\item{theta}{A Numeric scalar. Diversity clustering penalty parameter. Larger
values of theta result in more diverse clusters. theta=0 does not encourage
any diversity. Default \code{5}.}

\item{sigma}{A Numeric scalar. Width of soft kmeans clusters. Larger values
of sigma result in cells assigned to more clusters. Smaller values of sigma
make soft kmeans cluster approach hard clustering. Default \code{0.1}.}

\item{nIter}{An integer. The max number of iterations to perform. Default
\code{10L}.}

\item{seed}{Set seed for reproducibility. Default is \code{12345}.}

\item{verbose}{Whether to print progress messages. Default \code{TRUE}.}

\item{...}{Other arguments passed to \code{\link[harmony]{HarmonyMatrix}}.
See details.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{reducedDim(inSCE, reducedDimName)} updated.
}
\description{
Harmony is an algorithm that projects cells into a shared
embedding in which cells group by cell type rather than dataset-specific
conditions.
}
\details{
Since some of the arguments of \code{\link[harmony]{HarmonyMatrix}}
is controlled by this wrapper function. The additional arguments users can
work with only include: \code{nclust}, \code{tau}, \code{block.size},
\code{max.iter.cluster}, \code{epsilon.cluster}, \code{epsilon.harmony},
\code{plot_convergence}, \code{reference_values} and \code{cluster_prior}.
}
\examples{
data('sceBatches', package = 'singleCellTK')
logcounts(sceBatches) <- log1p(counts(sceBatches))
\dontrun{
if (require("harmony"))
    sceCorr <- runHarmony(sceBatches)
}
}
\references{
Ilya Korsunsky, et al., 2019
}
