% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyFindClusters}
\alias{runScanpyFindClusters}
\title{runScanpyFindClusters
Computes the clusters from the input sce object and stores them back in sce
object}
\usage{
runScanpyFindClusters(
  inSCE,
  useAssay = "scanpyScaledData",
  useReducedDim = "scanpyPCA",
  nNeighbors = 10,
  dims = 40,
  method = c("leiden", "louvain"),
  colDataName = NULL,
  resolution = 1,
  niterations = -1,
  flavor = "vtraag",
  use_weights = FALSE,
  cor_method = "pearson",
  inplace = TRUE,
  externalReduction = NULL,
  seed = 12345
)
}
\arguments{
\item{inSCE}{(sce) object from which clusters should be computed and stored
in}

\item{useAssay}{Assay containing scaled counts to use for clustering.}

\item{useReducedDim}{Reduction method to use for computing clusters. 
Default \code{"scanpyPCA"}.}

\item{nNeighbors}{The size of local neighborhood (in terms of number of 
neighboring data points) used for manifold approximation. Larger values 
result in more global views of the manifold, while smaller values result in 
more local data being preserved. Default \code{10}.}

\item{dims}{numeric value of how many components to use for computing
clusters. Default \code{40}.}

\item{method}{selected method to compute clusters. One of "louvain",
and "leiden". Default \code{louvain}.}

\item{colDataName}{Specify the name to give to this clustering result. 
Default is \code{NULL} that will generate a meaningful name automatically.}

\item{resolution}{A parameter value controlling the coarseness of the 
clustering. Higher values lead to more clusters Default \code{1}.}

\item{niterations}{How many iterations of the Leiden clustering method to 
perform. Positive values above 2 define the total number of iterations to 
perform, -1 has the method run until it reaches its optimal clustering.
Default \code{-1}.}

\item{flavor}{Choose between to packages for computing the clustering.
Default \code{vtraag}}

\item{use_weights}{Boolean. Use weights from knn graph. Default \code{FALSE}}

\item{cor_method}{correlation method to use. Options are ‘pearson’, 
‘kendall’, and ‘spearman’. Default \code{pearson}.}

\item{inplace}{If True, adds dendrogram information to annData object, 
else this function returns the information. Default \code{TRUE}}

\item{externalReduction}{Pass DimReduce object if PCA computed through
other libraries. Default \code{NULL}.}

\item{seed}{Specify numeric value to set as a seed. Default \code{12345}.}
}
\value{
Updated sce object which now contains the computed clusters
}
\description{
runScanpyFindClusters
Computes the clusters from the input sce object and stores them back in sce
object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
}
}
