% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_factor.R
\name{com_factor}
\alias{com_factor}
\title{Combine Factors in Targets File}
\usage{
com_factor(se, target, factors2com, sep = ".", factor.new)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object.}

\item{target}{A \code{data.frame} object of targets file.}

\item{factors2com}{A character vector of column names or a numeric vector of column indeces in the targets file. Entries in these columns are combined.}

\item{sep}{The separator in the combined factors. One of \code{_}, and \code{.} (default).}

\item{factor.new}{The column name of the new combined factors.}
}
\value{
If \code{se} is provided, a \code{SummarizedExperiment} object is returned, where the \code{colData} slot contains the new column of combined factors. Otherwise, a\code{data.frame} object is returned, where the new column of combined factors is appended.
}
\description{
This is a helper function for data/aSVGs involving three or more factors such as sample, time, condition. It combine factors in targets file to make composite factors.
}
\examples{
library(SummarizedExperiment)
mus.se.pa <- system.file('extdata/shinyApp/data/mus_brain_vars_se.rds', package='spatialHeatmap')
mus.se <- readRDS(mus.se.pa); targets.info <- colData(mus.se)
targets.new <- com_factor(target=targets.info, factors2com=c('time', 'treatment', 'injury'), factor.new='comDim')
}
\references{
Attilio, Peter J, Dustin M Snapper, Milan Rusnak, Akira Isaac, Anthony R Soltis, Matthew D Wilkerson, Clifton L Dalgard, and Aviva J Symes. 2021. “Transcriptomic Analysis of Mouse Brain After Traumatic Brain Injury Reveals That the Angiotensin Receptor Blocker Candesartan Acts Through Novel Pathways.” Front. Neurosci. 15 (March): 636259
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
