% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_cell_meta.R
\name{process_cell_meta}
\alias{process_cell_meta}
\title{Processing single cell RNA-seq count data}
\usage{
process_cell_meta(
  sce,
  qc.metric = list(threshold = 1),
  qc.filter = list(nmads = 3),
  quick.clus = list(min.size = 100),
  com.sum.fct = list(max.cluster.size = 3000),
  log.norm = list(),
  prop = 0.1,
  min.dim = 13,
  max.dim = 50,
  model.var = list(),
  top.hvg = list(n = 3000),
  de.pca = list(assay.type = "logcounts"),
  pca = FALSE,
  tsne = list(dimred = "PCA", ncomponents = 2),
  umap = list(dimred = "PCA")
)
}
\arguments{
\item{sce}{Single cell RNA-seq count data in \code{SingleCellExperiment}.}

\item{qc.metric}{Quality control arguments in a named list passed to \code{\link[scuttle]{perCellQCMetrics}}, such as \code{qc.metric=list(threshold=1)}.}

\item{qc.filter}{Quality control filtering arguments in a named list passed to \code{\link[scuttle]{perCellQCFilters}}, such as \code{qc.filter=list(nmads=3)}.}

\item{quick.clus}{Arguments in a named list passed to \code{\link[scran]{quickCluster}}, such as \code{quick.clus=list(min.size = 100)}.}

\item{com.sum.fct}{Arguments in a named list passed to \code{\link[scran]{computeSumFactors}}, such as \code{com.sum.fct=list(max.cluster.size = 3000))}.}

\item{log.norm}{Arguments in a named list passed to \code{\link[scuttle]{logNormCounts}}.}

\item{prop}{Numeric scalar specifying the proportion of genes to report as highly variable genes (HVGs) in \code{\link[scran]{getTopHVGs}}. The default is \code{0.1}.}

\item{min.dim, max.dim}{Integer scalars specifying the minimum (\code{min.dim}) and maximum (\code{max.dim}) number of (principle components) PCs to retain respectively in \code{\link[scran]{denoisePCA}}. The default is \code{min.dim=11}, \code{max. dim=50}.}

\item{model.var}{Additional arguments in a named list passed to \code{\link[scran]{modelGeneVar}}.}

\item{top.hvg}{Additional arguments in a named list passed to \code{\link[scran]{getTopHVGs}}, such as \code{top.hvg=list(n =   3000)}.}

\item{de.pca}{Additional arguments in a named list passed to \code{\link[scran]{denoisePCA}}, such as \code{de.pca=list(assay.  type = "logcounts")}.}

\item{pca}{Logical, if \code{TRUE} only the data with reduced dimentionality by PCA is returned and no clustering is performed. The default is \code{FALSE} and clustering is performed after dimensionality reduction.}

\item{tsne}{Additional arguments in a named list passed to \code{\link[scater]{runTSNE}}, such as \code{tsne=list(dimred="PCA", ncomponents=2)}.}

\item{umap}{Additional arguments in a named list passed to \code{\link[scater]{runUMAP}}, such as \code{umap=list(dimred="PCA")}.}
}
\value{
A \code{SingleCellExperiment} object.
}
\description{
A meta function for processing single cell RNA-seq count data, including quality control, normalization, dimensionality reduction.
}
\details{
In the QC, frequently used per-cell metrics are calculated for identifying problematic cells, such as library size, number of detected features above a threshold, mitochodrial gene percentage, etc. Then these metrics are used to determine outlier cells based on median-absolute-deviation (MAD). Refer to \code{perCellQCMetrics} and \code{perCellQCFilters} in the scuttle package for more details. 
In the normalization, a quick-clustering method is applied to divide cells into clusters. Then a scaling normalization method is performed to obtain per-cluster size factors. Next, the size factor in each cluster is decomposed into per-cell size factors by a deconvolution strategy. Finally, all cells are normalized by per-cell size factors. See more details in \code{quickCluster}, \code{computeSumFactors} from the scran package, and \code{logNormCounts} from the scuttle package.   
In dimensionality reduction, the high-dimensional gene expression data are embedded into a 2-3 dimensional space using PCA, tSNE and UMAP. All three embedding result sets are stored in a \code{SingleCellExperiment} object. Details are seen in \code{denoisePCA} from scran, and \code{runUMAP}, \code{runTSNE} from scater.
}
\examples{
library(scran); library(scuttle); library(SummarizedExperiment) 
sce <- mockSCE()
sce.dimred <- process_cell_meta(sce, qc.metric=list(subsets=list(Mt=rowData(sce)$featureType=='mito'), threshold=1))
}
\references{
Amezquita R, Lun A, Becht E, Carey V, Carpp L, Geistlinger L, Marini F, Rue-Albrecht K, Risso D, Soneson C, Waldron L, Pages H, Smith M, Huber W, Morgan M, Gottardo R, Hicks S (2020). “Orchestrating single-cell analysis with Bioconductor.” Nature Methods,    17, 137–145. https://www.nature.com/articles/s41592-019-0654-x.
McCarthy DJ, Campbell KR, Lun ATL, Willis QF (2017). “Scater: pre-processing, quality control, normalisation and visualisation  of single-cell RNA-seq data in R.” Bioinformatics, 33, 1179-1186. doi: 10.1093/bioinformatics/btw777.
Lun ATL, McCarthy DJ, Marioni JC (2016). “A step-by-step workflow for low-level analysis of single-cell RNA-seq data with Bioconductor.” F1000Res., 5, 2122. doi: 10.12688/f1000research.9501.2.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
