% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_svg.R
\name{write_svg}
\alias{write_svg}
\title{Exporting each spatial heatmap to a separate SVG file}
\usage{
write_svg(input, out.dir)
}
\arguments{
\item{input}{The output returned by \link{shm} or \link{covis}.}

\item{out.dir}{The directory path where the colored aSVG file will be saved.}
}
\value{
Nothing is returned.
}
\description{
This function exports each spatial heatmap (associated with a specific gene and condition) as separate SVG files. In contrast to the original aSVG file, spatial features in the output SVG files are assigned heat colors.
}
\examples{

# Read the aSVG file.
svg.hum.pa <- system.file("extdata/shinyApp/data", 'homo_sapiens.brain.svg', 
package="spatialHeatmap")
svg.hum <- read_svg(svg.hum.pa)
# Attributes of spatial features.
feature.hum <- attribute(svg.hum)[[1]]
set.seed(20) # To obtain reproducible results, a fixed seed is set.
# Spatial features.
unique(feature.hum$feature)[1:10]
# Create a random numeric vector.
my_vec <- setNames(sample(1:100, 4), c('substantia.nigra', 'putamen', 
'prefrontal.cortex', 'notMapped'))
my_vec
# Plot spatial heatmaps with the imported aSVG and random vector.
dat.quick <- SPHM(svg=svg.hum, bulk=my_vec)
shm.res <- shm(data=dat.quick, ID='testing', ncol=1, sub.title.size=20, legend.nrow=3,
bar.width=0.1)
# Export each spatial heatmap (under a certain gene and condition) to a separate SVG 
# file in a temporary directory.
write_svg(input=shm.res, out.dir=tempdir(check = TRUE))
}
\references{
Hadley Wickham, Jim Hester and Jeroen Ooms (2019). xml2: Parse XML. R package version 1.2.2. https://CRAN.R-project.org/package=xml2
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
