% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_weights.R
\name{generate_weights}
\alias{generate_weights}
\title{Generate weights}
\usage{
generate_weights(
  input,
  spatial_coords = NULL,
  assay_name = "counts",
  stabilize = TRUE,
  n_threads = 1,
  BPPARAM = NULL
)
}
\arguments{
\item{input}{either a SpatialExperiment object which contains a counts
matrix, or a counts matrix}

\item{spatial_coords}{matrix containing columns of spatial coordinates,
needed if input is a matrix}

\item{assay_name}{if using a SpatialExperiment object, name of the assay in
which the counts matrix is stored}

\item{stabilize}{when TRUE, stabilize weights to avoid extrapolation (highly
recommended)}

\item{n_threads}{default = 1, number of threads for parallelization}

\item{BPPARAM}{optional additional argument for parallelization to use
BiocParallel}
}
\value{
weights matrix
}
\description{
Generate weights on the observation level for each gene
}
\details{
This function generates weights for each observation, which are used
as input to scale the data and covariates
}
\examples{
library(nnSVG)
library(STexampleData)
library(SpatialExperiment)
library(BRISC)
library(BiocParallel)
library(scuttle)


spe <- Visium_humanDLPFC()

# keep spots over tissue
spe <- spe[, colData(spe)$in_tissue == 1]

# filter low-expressed and mitochondrial genes
spe <- filter_genes(spe)

# calculate logcounts (log-transformed normalized counts) using scran package
spe <- computeLibraryFactors(spe)
spe <- logNormCounts(spe)

known_genes <- c("MOBP", "PCP4", "SNAP25", "HBB", "IGKC", "NPY")
ix_known <- which(rowData(spe)$gene_name \%in\% known_genes)
ix <- c(ix_known)

spe <- spe[ix, ]

spe <- spe[, colSums(logcounts(spe)) > 0]

#EXAMPLE 1 USING SPATIAL EXPERIMENT

set.seed(1)
weights_1 <- generate_weights(input = spe,
                              stabilize = TRUE)

#EXAMPLE 2 USING MATRIX

counts_mat <- counts(spe)
logcounts_mat <- logcounts(spe)
coords_mat <- spatialCoords(spe)

set.seed(1)
weights_2 <- generate_weights(input = counts_mat,
                              spatial_coords = coords_mat,
                              stabilize = TRUE)

}
