% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blank_filter_class.R
\name{blank_filter}
\alias{blank_filter}
\title{Blank filter}
\usage{
blank_filter(
  fold_change = 20,
  blank_label = "blank",
  qc_label = "QC",
  factor_name,
  fraction_in_blank = 0,
  ...
)
}
\arguments{
\item{fold_change}{(numeric) Features with fold change less than this value are removed. The default is \code{20}.\cr}

\item{blank_label}{(character) The label used to identify blank samples. The default is \code{"blank"}.}

\item{qc_label}{(character, NULL) The label used to identify QC samples. If set to NULL then the median of the samples is used. The default is \code{"QC"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{fraction_in_blank}{(numeric) Features present in less than this proportion of the blanks are not considered for removal. The default is \code{0}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{blank_filter} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object containing the filtered data. \cr
\code{flags} \tab          (data.frame) A flag indicating whether the feature was rejected  or not. \cr
}
}
\description{
A blank filter filters features by comparing the median intensity of blank samples to the median intensity of samples. Features where the relative intensity (fold change) is not large when compared to the blank are removed. The number of times a feature is detected across all blank samples may also be considered. If the feature is not detected in a high enough proportion of the blanks then it is not removed.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{blank_filter} object inherits the following \code{struct} classes: \cr\cr
\verb{[blank_filter]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = blank_filter(
      fold_change = 20,
      blank_label = "Blank",
      qc_label = "QC",
      factor_name = "V1",
      fraction_in_blank = 0)

D = iris_DatasetExperiment()
M = blank_filter(fold_change=2,
                 factor_name='Species',
                 blank_label='setosa',
                 qc_label='versicolor')
M = model_apply(M,D)
}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.
}
