% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSDA_charts.R
\name{pls_regcoeff_plot}
\alias{pls_regcoeff_plot}
\title{pls_regcoeff_plot class}
\usage{
pls_regcoeff_plot(ycol = 1, ...)
}
\arguments{
\item{ycol}{(character, numeric, integer) The Y column to plot. The default is \code{1}.\cr}

\item{...}{additional slots and values passed to struct_class}
}
\value{
A  \code{
pls_regcoeff_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.

struct object
}
\description{
Plots the regression coefficients of a PLSDA model.

Plots the regression coefficient scores of a PLSDA model
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pls}} \item{\code{ggplot2}}}
}
\section{Inheritance}{

A \code{pls_regcoeff_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[pls_regcoeff_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = pls_regcoeff_plot(
      ycol = 1)

D = iris_DatasetExperiment()
M = mean_centre()+PLSDA(factor_name='Species')
M = model_apply(M,D)

C = pls_regcoeff_plot(ycol='setosa')
chart_plot(C,M[2])
}
\references{
Liland K, Mevik B, Wehrens R (2023). \emph{pls: Partial Least Squares and
Principal Component Regression}. R package version 2.8-3,
\url{https://CRAN.R-project.org/package=pls}.

Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
